/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
/*globals window, util, uReleaseConfig, i18n, define*/

define([
  "dojo/_base/declare",
  "dojo/_base/array",
  "dojo/_base/lang",
  "dojo/on",
  "dojo/dom-class",
  "dojo/dom-construct",
  "app/widgets/ResourceRow",
  "app/model/ResourceRegistry"
], function(
    declare,
    array,
    lang,
    on,
    domClass,
    domConstruct,
    ResourceRow,
    Registry
) {
    return declare("app/widgets/notification/NotificationSchemeRow", [ResourceRow], {

      /**
       *
       */
       postCreate: function() {
         this.inherited(arguments);
         domClass.add(this.domNode, "resource-row notification-scheme-list-item");
       },

       /**
        *
        */
        getColumns: function() {
            var _this = this;
            return [{
                    "name": i18n("Name"),
                    "width": "20%",
                    "formatter": function() {
                        var content = domConstruct.create("a", {
                          className: "notification-item-name",
                          "innerHTML": (!!_this.model.get("name")) ? _this.model.getHTML("name") : null,
                          "href": uReleaseConfig.urls.base + "notificationSchemes/" + _this.model.get("id")
                        });

                        return content;
                    },
                    "getValue": function() {
                        return _this.model.getHTML("name");
                    },
                    "fieldData": {
                        "type": "Validation Text",
                        "name": "name",
                        "label": i18n("Name"),
                        "required": "true",
                        "missingMessage": i18n("A name is required"),
                        "placeHolder": i18n("Name")
                    }
                  }, {
                      "name": i18n("Description"),
                      "getValue" : function() {
                          return _this.model.getHTML("description");
                      },
                      "formatter": function() {
                          return _this.model.get("description") ? _this.model.getHTML("description").replace(/(?:\r\n|\r|\n)/g, '<br />') : "";
                      },
                      "fieldData": {
                          "name": "description",
                          "label": _this.newModel ? "" : i18n("Description"),
                          "getField": function() {
                              _this.createExtraFieldRow({
                                  label: i18n("Description"),
                                  type: "Text Area",
                                  value: _this.model.getHTML("description"),
                                  name: "description",
                                  "style": {
                                      "width": "600px"
                                  }
                              });

                              return domConstruct.create("div", {
                                  "class": "ruleFormRow"
                              });
                          }
                      }
                  }
            ];
          }
    });
});
