/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, i18n*/
define([
  "dojo/_base/declare",
  "dojo/_base/array",
  "dojo/dom-construct",
  "dojo/dom-class",
  "dojo/on",
  "dojo/dom",
  "dijit/form/Button",
  "dijit/Tooltip",
  "js/webext/widgets/Alert",
  "js/webext/widgets/ContentContainer",
  "js/webext/widgets/ColumnForm",
  "js/webext/widgets/RestSelect",
  "app/model/notification/NotificationRules",
  "app/widgets/notification/NotificationRuleRow",
  "app/widgets/ResourceTable",
  "app/widgets/SubLevelTabManager",
  "app/widgets/UReleaseWidget",
  "dojo/request/xhr"
], function(
      declare,
      array,
      domConstruct,
      domClass,
      on,
      dom,
      Button,
      Tooltip,
      Alert,
      ContentContainer,
      ColumnForm,
      RestSelect,
      NotificationRule,
      NotificationRuleRow,
      ResourceTable,
      TabManager,
      UReleaseWidget,
      xhr
) {
    return declare("app/widgets/notification/NotificationRulesView", [UReleaseWidget], {
          templateString:
              '<div class="content-container">' +
                  '<div data-dojo-attach-point="schemeNameAP" class="notification-scheme-name"></div>' +
                  '<div data-dojo-attach-point="schemeLinkAP" class="notification-link-container"></div>' +
                  '<div data-dojo-attach-point="schemeDetailsAP" class="scheme-details-container"></div>' +
                  '<div data-dojo-attach-point="entityTabsAP" class="notification-type-tabs tab-container"></div>' +
                  '<div data-dojo-attach-point="contentAP" class="notification-rules-content"></div>' +
                  '<div class="notification-rule-submit" data-dojo-attach-point="buttonAP"></div>' +
              '</div>',

              /**
               *
               */
               postCreate: function() {
                 var _this = this;
                 this.inherited(arguments);
                 this._initializeSchemeDetails();
                 this._initializeEntityTabs();
                 if (!_this.readOnly) {
                     this.addSubmitButton();
                 }
               },
               addSubmitButton: function() {
                  var _this = this;
                  _this.submitButton = new Button({
                      "label": i18n("Save"),
                      "class": "notification-save-all idxButtonSpecial"
                  });
                  _this.submitButton.placeAt(_this.buttonAP);
               },
               _initializeSchemeDetails: function() {
                  var _this = this;
                  _this.schemeNameAP.innerHTML = _this.model.get("name");
                  // Show link to scheme if on Notifications Tab under a Scheduled Deployments
                  if (!!_this.model.canWrite() && !!_this.readOnly) {
                      domConstruct.create('a', {innerHTML: i18n('Edit Scheme'), "href": uReleaseConfig.urls.base + "notificationSchemes/" + _this.model.get("id")}, _this.schemeLinkAP);
                      domConstruct.create('div', {className: "scheme-edit-desc", innerHTML:i18n("This will affect everything using this scheme")}, _this.schemeLinkAP);
                  }
               },

               _initializeEntityTabs: function(callback) {
                  var _this = this;
                  var tabs = [];
                  _this.allTableChildren = [];
                  // Each notification entity type will have its own tab
                  xhr.get(uReleaseConfig.urls.base + "notificationRules/entityTypes", {
                      handleAs: "json",
                      headers: {"Accept": "application/json"}
                  }).then(function(data) {

                      array.forEach(data, function(entity) {
                        var entityTab = {
                            label: entity.name,
                            hash: entity.name,
                            populate: function(node) {
                              // An entity type event has a corresponding resource table
                              xhr.get(uReleaseConfig.urls.base + "notificationRules/" + entity.value + "/events", {
                                  handleAs: "json",
                                  headers: {"Accept": "application/json"}
                              }).then(function(data) {
                                    var notifyEvents = data;
                                    array.forEach(notifyEvents, function(event) {
                                    // Get all rules with certain entity type and particular event
                                    var members = array.filter(_this.model.get("notifications").getMembers(), function(item) {
                                        return item.get("type") === entity.name && item.get("event") === event.value;
                                    });
                                    // Each member is a notification rule
                                    var rules = new NotificationRule([], _this.model);
                                    array.forEach(members, function(m) {
                                      m.hasOffset = event.hasOffset;
                                      m.entity = entity;
                                      m.readOnly = !_this.readOnly ? false : _this.readOnly;
                                      _this.allTableChildren.push(m);
                                      rules.addMember(m);
                                    });

                                    // Each notification event has its own table
                                    var rulesContainer = new ContentContainer({
                                        header: event.name
                                    });
                                    var helpDiv = domConstruct.create("div",{className: "notification-rules-help-icon inlineBlock"}, rulesContainer.subheaderAttach);
                                    var helpIcon = domConstruct.create("div", {className: "labelsAndValues-helpCell"}, helpDiv);
                                    var helperText = new Tooltip({
                                        connectId: helpIcon,
                                        label: event.detail
                                    });
                                    if (!!_this.readOnly && rules.getMembers().length === 0) {
                                        return;
                                    }
                                    var table = new ResourceTable({
                                        "type": entity.value,
                                        "eventType": event,
                                        "model": rules,
                                        "widgetClass": NotificationRuleRow,
                                        "addLabel": null,
                                        "textButton": true,
                                        "textButtonClass": "add-rule-btn",
                                        "textButtonIcon": "notification-rule-item rd-task-tag-add-btn"
                                    });
                                    rulesContainer.placeAt(node);
                                    table.placeAt(rulesContainer.containerAttach);
                                    if (!_this.readOnly) {
                                        var addButton = domConstruct.create("div", {className: 'notification-rule-item rd-task-tag-add-btn add-rule-btn inline-block'}, table.paginationAttachBelow);

                                        // Notify user of unsaved changes when navigating away from page
                                        window.onbeforeunload =  function() {
                                          var unSavedItems = array.filter(_this.allTableChildren, function(child) {
                                              return child.get("isSaved") === false;
                                          });

                                          if (unSavedItems.length > 0) {
                                              return i18n("This page contains unsaved changes.");
                                          }
                                        };
                                        _this.own(on(addButton, "click", function() {
                                            var newRuleModel = new NotificationRule({}, _this.model);
                                            newRuleModel.hasOffset = table.eventType.hasOffset;
                                            newRuleModel.entity = entity;
                                            _this.newChild = new NotificationRuleRow({
                                                "containingList": table,
                                                "model": newRuleModel,
                                                "listModel": table.model,
                                                "className": "resource",
                                                "notifyType": "all"
                                            });
                                            _this.allTableChildren.push(newRuleModel);
                                            table._placeChildWidget(_this.newChild);
                                            table.model.addMember(_this.newChild.model);
                                        }));

                                        // Iterate through all tab tables and save each row
                                        _this.own(on(_this.submitButton, "click", function() {
                                            array.forEach(table.childWidgets, function(child) {
                                                child.onSave();
                                            });
                                        }));
                                    }
                                });
                            });
                          }

                        };
                        tabs.push(entityTab);
                    });

                    if(tabs.length > 0) {
                    var tabManager = new TabManager({
                        tabNode: _this.entityTabsAP,
                        subConfiguration: tabs
                    });

                    tabManager.placeAt(_this.contentAP);
                  }
                  });
               }
    });
});
