/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
/*globals window, util, uReleaseConfig, i18n, define*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/on",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/request/xhr",
    "dijit/form/NumberSpinner",
    "dijit/form/Select",
    "js/webext/widgets/Alert",
    "js/webext/widgets/RestSelect",
    "app/widgets/ResourceRow",
    "dijit/form/ValidationTextBox",
    "app/widgets/select/WebextSelectXhrMemory"
], function(
    declare,
    array,
    on,
    domClass,
    domConstruct,
    xhr,
    NumberSpinner,
    Select,
    Alert,
    RestSelect,
    ResourceRow,
    TextBox,
    WebextSelectXhrMemory
) {
    return declare("app/widgets/notification/NotificationRuleRow", [ResourceRow], {
      /**
       *
       */
       postCreate: function() {
         // Cannot delete rules on scheduled deployment Notifications tab
         if (!!this.model.readOnly) {
               this.model.canDelete = function() {
                   return false;
               };
           }
         this.inherited(arguments);
         var _this = this;
         domClass.add(this.domNode, "resource-row notification-rule-list-item");
       },

       /**
        *
        */
        getColumns: function() {
            var _this = this;
            return [{
                "name": "&nbsp;",
                "minWidth": "20%",
                "formatter": function() {
                    var content = domConstruct.create("div", {});
                    var labelSpan = domConstruct.create("span", {innerHTML: i18n("Notify"), className: "notification-rule-label inlineBlock" }, content);
                    var roleSelectContainer = domConstruct.create("div", {className: "inline-block notification-ruleValue-container role-select-container"}, content);
                    var groupSelectContainer = domConstruct.create("div", {className: "inline-block notification-ruleValue-container"});
                    var notifyTarget;
                    // Check model for definted user, role, group, all, email
                    if (_this.model.get("user")) {
                      notifyTarget = "USER";
                    } else if (_this.model.get("role")) {
                      notifyTarget = "ROLE";
                    } else if (_this.model.get("group")) {
                      notifyTarget = "GROUP";
                    } else if (_this.model.get("email")) {
                      notifyTarget = "EMAIL";
                    } else {
                      notifyTarget = "ALL";
                    }

                    _this.roleSelect = new RestSelect ({
                       "autoSelectFirst": false,
                       "allowNone": false,
                       "value": notifyTarget,
                       "className": "notification-rule-select",
                       "restUrl": uReleaseConfig.urls.base + "notificationRules/recipientTypes",
                       "disabled": _this.model.readOnly,
                       "getLabel": function(item) {
                           return item.name;
                       },
                       "getValue": function(item) {
                           return item.value;
                       },
                       "onChange": function(value, item) {
                          if (!!value) {
                              switch (value) {
                                  case "USER":
                                      dojo.empty(groupSelectContainer);
                                      var user = _this.getAttributeId("user");
                                      _this.targetSelect = new RestSelect({
                                          "disabled": _this.model.readOnly,
                                          "allowNone": false,
                                          "value": (!!user) ? user : null,
                                          "name": "user",
                                          "restUrl": uReleaseConfig.urls.base + "users/?format=name",
                                          "onChange": function(item, value) {
                                              // mark change as unsaved if modified inline (not a newly added rule)
                                              _this.setSaveState("user", item);
                                          }
                                       }).placeAt(groupSelectContainer);
                                       break;
                                    case "ROLE":
                                        dojo.empty(groupSelectContainer);
                                        var role = _this.getAttributeId("role");
                                        _this.targetSelect = new RestSelect({
                                            "disabled": _this.model.readOnly,
                                            "allowNone": false,
                                            "name": "role",
                                            "value": (!!role) ? role: null,
                                            "restUrl": uReleaseConfig.urls.base + "roles/?format=name",
                                            "onChange": function(item, value) {
                                                // mark change as unsaved if modified inline (not a newly added rule)
                                                _this.setSaveState("role", item);
                                            }
                                         }).placeAt(groupSelectContainer);

                                         break;
                                     case "GROUP":
                                         dojo.empty(groupSelectContainer);
                                         var group = _this.getAttributeId("group");
                                         _this.targetSelect = new WebextSelectXhrMemory({
                                             "disabled": _this.model.readOnly,
                                             "allowNone": false,
                                             "name": "group",
                                             "value": (!!group) ? group: null,
                                             "target": uReleaseConfig.urls.base + "groups?format=name",
                                             "onLoad": function() {
                                                 // make sure we do the same stuff on load as on change
                                                 this.onChange(this.value);
                                             },
                                             "onChange": function(item, value) {
                                                 // mark change as unsaved if modified inline (not a newly added rule)

                                                 _this.setSaveState("group", item);
                                             }
                                          }).placeAt(groupSelectContainer);
                                          break;
                                    case "ALL":
                                       dojo.empty(groupSelectContainer);
                                       _this.targetSelect = new RestSelect({
                                            "allowNone": true,
                                            "value": "all",
                                            "name": "all",
                                            "restUrl": uReleaseConfig.urls.base + "roles?format=name",
                                            "disabled": true
                                         });
                                         // If rule does not have the following notify types, option 'All' is selected
                                         if ((_this.model.get("user") || _this.model.get("role") || _this.model.get("group")) && !_this.model.isBlankModel) {
                                            _this.model.set("isSaved", false);
                                         }
                                         break;
                                     case "EMAIL":
                                        //Show Text Box
                                          dojo.empty(groupSelectContainer);
                                          _this.targetSelect = new TextBox({
                                              "readOnly": _this.model.readOnly,
                                              name: "email",
                                              required: "true",
                                              value: _this.model.get("email"),
                                              placeHolder: i18n("Email Address"),
                                              "onChange": function(item, value) {
                                                  // mark change as unsaved if modified inline (not a newly added rule)
                                                _this.setSaveState("email", item);
                                              }
                                          }).placeAt(groupSelectContainer);
                                          break;
                              }
                          } else {
                                _this.targetSelect = new WebextSelectXhrMemory({
                                   "allowNone": true,
                                   "target": uReleaseConfig.urls.base + "roles?format=name",

                                   "onLoad": function() {
                                       // make sure we do the same stuff on load as on change
                                       this.onChange(this.value);
                                   },
                                   "readOnly": true
                                }).placeAt(groupSelectContainer);
                          }
                       }
                    });

                    _this.roleSelect.placeAt(roleSelectContainer);
                    domConstruct.place(groupSelectContainer, content);
                    return content;
                }
            }, {
              "name": "&nbsp;",
              "minWidth": "20%",
              "formatter": function() {
                  var content = domConstruct.create("div",{});

                  var labelSpan = domConstruct.create("span", {innerHTML: i18n("Owned By"), className: "notification-rule-label inlineBlock"}, content);
                  xhr.get(uReleaseConfig.urls.base + 'notificationRules/filterTypes', {
                      handleAs: "json",
                      headers: {
                        "accept": "application/json"
                      }
                  }).then(function(data) {
                        // Owner options are determined by the spefications defined by the entity type
                        var ownerSelectContainer = domConstruct.create("div", {className: "inline-block notification-ruleValue-container role-select-container"}, content);
                        var entity = _this.model.entity;
                        var selectOptions = data;
                          var filteredOptions = [];
                         if (!!entity.hasRole || !!entity.hasGroup) {
                             var roleOptions = array.filter(selectOptions, function(option) {
                                 return option.value === "MY_ROLE";
                             });

                             array.forEach(roleOptions, function(o) {
                                 o.label = o.name;
                                 filteredOptions.push(o);
                             });
                         }
                         if (!!entity.hasUser) {
                             var userOptions = array.filter(selectOptions, function(option) {
                                 return option.value === "USER" || option.value === "OWNED_BY_ME";
                             });
                             array.forEach(userOptions, function(o) {
                                 o.label = o.name;
                                 filteredOptions.push(o);
                             });
                         }
                          // "All" is always an owner option regardless of entity type
                          var allOptions = array.filter(selectOptions, function(option) {
                             return option.value === "ALL";
                         });
                         array.forEach(allOptions, function(o) {
                             o.label = o.name;
                             filteredOptions.push(o);
                         });

                        // Create 'owned by' select with the options defined above
                        _this.ownerSelect = new Select({
                            "disabled": _this.model.readOnly,
                            "autoSelectFirst": false,
                            "allowNone": false,
                            "name": "filter",
                            "value": !_this.model.getHTML("filter") ? "" : _this.model.getHTML("filter"),
                            "options": filteredOptions,
                            "className": "notification-rule-select",
                            "getLabel": function(item) {
                                return item.name;
                            },
                            "getValue": function(item) {
                                return item.value;
                            },
                            "onChange": function(item, value) {
                                // mark change as unsaved if modified inline (not a newly added rule)
                                _this.setSaveState("filter", item);
                            }
                        });
                      _this.ownerSelect.placeAt(ownerSelectContainer);
                  });
                  return content;
              }
            },{
              "name": "&nbsp;",
              "width": "20%",
              "formatter": function() {
                  var content = domConstruct.create("div",{});
                  var labelSpan = domConstruct.create("span", {innerHTML: i18n("Template"), className: "notification-rule-label inlineBlock"}, content);
                  var templateSelectContainer = domConstruct.create("div", {className: "inline-block notification-ruleValue-container role-select-container"}, content);

                  var template = _this.getAttributeId("template");
                  _this.templateSelect = new RestSelect({
                      "disabled": _this.model.readOnly,
                      "autoSelectFirst": false,
                      "allowNone": false,
                      "name": "template",
                      "value": !_this.newModel && !!template ? template : "",
                      "className": "notification-rule-select",
                      "restUrl": uReleaseConfig.urls.base + "notificationTemplates/",
                      "getLabel": function(item) {
                          return item.name;
                      },
                      "getValue": function(item) {
                          return item.id;
                      },
                      "onChange": function(item, value) {
                          // mark change as unsaved if modified inline (not a newly added rule)
                          _this.setSaveState("template", item);
                      }
                  });
                  _this.templateSelect.placeAt(templateSelectContainer);
                  return content;
              }
            }, {
              "name": "&nbsp",
              "width": "20%",
              "formatter": function() {
                  var content = domConstruct.create("div", {});
                  if (!!_this.model.hasOffset) {
                      var labelSpan = domConstruct.create("span", {innerHTML: i18n("Offset"), className: "notification-rule-label offset-label inlineBlock"}, content);
                      var offsetSelectContainer = domConstruct.create("div", {className: "inline-block notification-ruleValue-container role-select-container"}, content);

                      _this.offsetSelect = new NumberSpinner({
                          "name": "offset",
                          "disabled": _this.model.readOnly,
                          value: !!_this.model.get("offset") ? _this.model.get("offset") : 0,
                          constraints: { min: 0, places: 0},
                          style: "width: 100px",
                          intermediateChanges: true,
                          "onChange": function(value) {
                            if (!!_this.model.isBlankModel) {
                                _this.model.set("isSaved", true);
                            }
                            else {
                                _this.model.set("isSaved", false);
                              }
                          }
                      });
                      _this.offsetSelect.placeAt(offsetSelectContainer);
                }
                  return content;
              }
            }
          ];
        },

        preSave: function() {
          var _this = this;
          if (!!this.model.get("id")) {
              this.model.set("id", this.model.get("id"));
          }
          _this.model.set("isSaved", true);
          var scheme = this.model.getRootParent();
          this.model.set("scheme", scheme.get("id"));

          var entityType = this.getParent().type;
          this.model.set("type", entityType);

          var eventType = this.getParent().eventType.value;
          this.model.set("event", eventType);
          if (!!(_this.targetSelect && _this.targetSelect.value)) {
            this.model.set("notifyType", _this.targetSelect.name);
            this.model.set(_this.targetSelect.name, _this.targetSelect.value);
          }

          this.model.set("filter", _this.ownerSelect.value);
          this.model.set("template", _this.templateSelect.value);
          if (!!this.getParent().eventType.hasOffset) {
                this.model.set("offset", _this.offsetSelect.value);
          }

        },

        postSave: function(response) {
          // If we're creating a new object, add it to the parent model if one is given
          if (this.newModel && this.listModel) {
              // If the response has a relative position defined (index can be zero and even -1)
              if (!!response && (response.relativePosition !== null) && (response.relativePosition !== undefined)) {
                  this.listModel.addMember(this.model, response.relativePosition.valueOf()-1);
              }
              else {
                  this.listModel.addMember(this.model);
              }
          }
          this.newModel = false;
        },

        setupExpandButtonBehavior : function() {
          var _this = this;

             if (this.model) {
                 if (this.model.canExpand()) {

                     // show the expand/edit button
                     _this._showExpand();

                     // this.doubleClickExpandNode is set to this.domNode by default,
                     // but can be overridden to be any node.
                     this.own(on(this.doubleClickExpandNode, "dblclick", function(event) {

                         // prevent double-clicking on a nested ResourceView from
                         // also expanding its containing ResourceView

                         event.stopPropagation();
                         // Prevent selecting text on double click.
                         _this.deselectCursorText();

                         // unless double click is disabled, or this is already
                         // expanded, toggle it.
                         if (!_this.disableDoubleClick && !_this.expanded){
                             _this.toggleExpanded();
                         }
                     }));


                 } else { // if !this.model.canExpand()
                     domClass.add(this.expandAttach, "hidden");
                 }

                 // if we are the root in a hierarchy of resources
                 if (!this.model.parent) {
                     // refresh the row when the model is loaded
                     // and the row is collapsed
                     this.model.addChangeListener(function() {
                         if (!_this.expanded) {
                             _this.refresh();
                         }
                     }, this);
                 }

                 // if there is no resource id on the model, this is a newModel
                 this.newModel = !this.model.resourceId && this.id.indexOf("NotificationRuleRow") === -1;
                 if (!!this.newModel) {
                     // a new model starts expanded
                     this.toggleExpanded();
                 }
                 //XXX if it's not a new model, refresh the widget?? Eh?
                 else {
                     this.refresh();
                 }

                 if(this.loadExpandedState()) {
                     this.toggleExpanded();
                 }
             }
        },

        setSaveState: function(attrName, item) {
            var _this = this;
            if (!!_this.model.isBlankModel) {
                _this.model.set("isSaved", true);
            } else if (!!item && !_this.model.isBlankModel) {
                // A valid property can be in object or string ID form
                if (!!_this.model.get(attrName) && (
                  (typeof _this.model.get(attrName) === "object" && _this.model.get(attrName).get("id") !== item) ||
                  (typeof _this.model.get(attrName) !== "object" && _this.model.get(attrName) !== item))) {
                      _this.model.set("isSaved", false);
                  // Notification Template is an object
                } else if (!_this.model.get(attrName)) {
                      _this.model.set("isSaved", false);
                } else {
                      _this.model.set("isSaved", true);
                }
            }
        },

        getAttributeId: function(attrName) {
            var _this = this;
            var element = "";
            if (_this.model.get(attrName)) {
                element = _this.model.get(attrName);
                if (typeof element === 'object') {
                    element = _this.model.get(attrName).get("id");
                }
            }
            return element;
        },

        deleteFunction: function() {
            this.model.set("isSaved", true);
            this.inherited(arguments);
        }
    });
});
