/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define*/
define([
    "dojo/_base/declare",
    "dojo/Deferred",
    "app/model/ResourceRegistry"
], function (
    declare,
    Deferred,
    Registry
) {
    return declare([],{
        /**
         * the instance of the resource this view uses
         */
        resource : null,
        /**
         * @private
         * the classname of the resource this view uses
         */
        _Resource : null,
        /**
         * @private
         * load this widget's resource, if it hasn't already been loaded
         */
        _initializeResource: function (Resource, resourceData) {

            // if the widget doesn't know what class of resource it is backed by, but we are passing in a resource,
            // make the widget's backed-by resource the passed in resource, for all future reference.
            if(!this.Resource && !!Resource) {
                this.set('Resource', Resource);
            }
            // if there is still no resource, meaning that Resource was not passed in, or this.Resource is undefined,
            // something isn't being used right, and we should let the developer know.
            if(!this.Resource){
                throw new Error(i18n('implementations using app/widgets/mixins/_ResourceMixin must define a Resource class for this.resource, --or-- have the Resource class passed to this method as the irst argument.'));
            }
            // prepare the promise
            var deferred = new Deferred();

            // if the backing resource instance is falsy, we assume it hasn't been loaded yet, and...
            if(!this.resource) {
                // ...ask the registry to get it by classname, instantiating it with any preconfigured data that we want
                this.resource = new Registry().get(this.Resource, resourceData);
            }

            // if the resource says is has not yet been loaded,
            if (!this.resource.isLoaded()) {

                // we need to load it, sending us off into async land..
                this.resource.load().then(function (data) {
                    deferred.resolve(data);
                });
            } else {
                // otherwise, the resource is already loaded, and we can just resolve the promise now instead of waiting
                // until after the resource loaded.
                deferred.resolve();
            }
            return deferred.promise;
        }
    });
});
