/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig*/
define([
    "dojo/_base/declare"
], function (
    declare
) {
    /*
     * This mixin allows us to cache values so that we do not need to make the same request
     * multiple times for a single page.  For example, this is currently used in ResourceRow
     * to get the integration providers with properties to determine which fields are editable.
     * Rather than get the IP for each entity, we get all of them once then reference the cache.
     *
     * Methods are:
     * putCache(key, value) - store a value in the cache with the given key
     * getCache(key) - get the value from the cache for the given key
     * getCacheFromClass(classname, key) - get the value from the cache for the given key for the given class
     * clearCache() - clear the cache for the current class
     */
    return declare([],{
        /**
         * Store a value in the cache with the given key
         */
        putCache: function (key, value) {
            var classname = this.declaredClass;
            //create a namespace for class if it doesnt exist
            //cache is defined in imports.tag
            if (!uReleaseConfig.cache[classname]) {
                uReleaseConfig.cache[classname] = {};
            }
            //store the value
            uReleaseConfig.cache[classname][key] = value;
        },
        /**
         * Get a value from the cache
         */
        getCache: function (key) {
            var classname = this.declaredClass;
            //return undefined if no values are in the cache
            //cache is defined in imports.tag
            if (!uReleaseConfig.cache[classname]) {
                return undefined;
            }
            //return the value
            return uReleaseConfig.cache[classname][key];
        },
        /**
         * Get a value from the cache from any class
         */
        getCacheFromClass: function (classname, key) {
            //return undefined if no values are in the cache
            //cache is defined in imports.tag
            if (!uReleaseConfig.cache[classname]) {
                return undefined;
            }
            //return the value
            return uReleaseConfig.cache[classname][key];
        },
        /**
         * clear the cache for this class
         */
        clearCache: function () {
            var classname = this.declaredClass;
            //cache is defined in imports.tag
            if (uReleaseConfig.cache[classname]) {
                delete uReleaseConfig.cache[classname];
            }
        }
    });
});
