/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dijit/form/CheckBox"
], function (
    declare,
    array,
    domClass,
    domConstruct,
    Checkbox
) {
    /**
     * XXX this mixin is unused.
     */
    return declare([],{

        selectAll: function() {
            this._setCheckedState(true);
        },

        selectNone: function() {
            this._setCheckedState(false);
        },

        _setCheckedState: function(value) {
            array.forEach(this.childWidgets, function(childWidget) {
                if (!domClass.contains(childWidget.domNode, "does-not-match-filter")) {
                    childWidget.set('checked', value);
                }
            });
        },

        /**
         *
         */
        _getUncheckedWidgets: function () {
            var set = [];
            array.forEach(this.checkboxes, function (cb) {
                if(cb.get('value') !== 'on') {
                    set.push(cb);
                }
            });
            return set;
        },

        /**
         *
         */
        _getCheckedWidgets: function () {
            var set = [];
            array.forEach(this.checkboxes, function (cb) {
                if(cb.get('value')) {
                    set.push(cb);
                }
            });
            return set;
        },

        /**
         *
         */
        _getCheckedAttr: function () {
            return array.map(this._getCheckedWidgets(), function (cb) {
                return cb.get('value');
            });
        },

        /**
         *
         */
        _addCheckboxColumn: function (id, destination, position) {
            if(!this.checkboxes) {
                this.checkboxes = [];
            }
            var cb = new Checkbox({value:id});
            cb.__value = id;
            this.checkboxes.push(cb);
            domConstruct.place(cb.domNode, destination , position);
        }
    });
});
