/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/topic",
    "dijit/_WidgetBase",
    "app/widgets/mixins/_MemoryCacheMixin"
], function(
    declare,
    topic,
    _WidgetBase,
    _MemoryCacheMixin
) {
    var CACHE_NAME = "beingEdited";
    var CACHE_TOPIC_POSTFIX = ":edit";

    return declare("app/widgets/_CacheEditStateMixin",
        [ _WidgetBase, _MemoryCacheMixin ], {
        /*************************************************************
         * PUBLIC PROPERTIES AND METHODS
         *************************************************************/

        /**
         * add this id to a list of edited tasks
         * @see app/widgets/segment/DeploymentPlanView
         */
        addToEditCache: function () {
            var editedCache = this.getCache(this._getCacheName());
            if(!editedCache) {
                editedCache = {};
            }

            // add this tasks id to the list of properties in the tracking
            // object we don't care what the value is, right now, just
            // that the property exists on the object
            editedCache[this._getId()] = 1;
            this.putCache(this._getCacheName(), editedCache);

            // declaredClass is either
            // "app/widgets/segment/SegmentExecutionView"
            // or "app/widgets/task/TaskExecutionRow"
            topic.publish(this._getTopicName(), CACHE_NAME);
        },

        /**
         * remove this task's Id to a list of edited
         * tasks @see app/widgets/segment/DeploymentPlanView
         */
        removeFromEditCache: function () {
            var editedTasksCache = this.getCache(this._getCacheName());

            // if we have a cache to check, and if the task entry exists,
            // remove it from the list of properties in the tracking object
            if(editedTasksCache &&
               editedTasksCache.hasOwnProperty(this._getId())) {
                delete editedTasksCache[this._getId()];
                this.putCache(this._getCacheName(), editedTasksCache);
            }

            topic.publish(this._getTopicName(), CACHE_NAME);
        },

        /*************************************************************
         * PRIVATE PROPERTIES AND METHODS
         *************************************************************/
        /**
         * return the cache name for this declaredClass
         */
        _getCacheName: function () {
            return CACHE_NAME;
        },

        /**
         * return the composit name of the topic that should be published
         */
        _getTopicName: function () {
            return this.declaredClass + CACHE_TOPIC_POSTFIX;
        },
        /**
         * return the id of this widget
         */
        _getId: function () {
            // this is the dijit id of this instance of the widget,
            // not the resource id.
            return this.id;
        }
    });
});
