/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/dom-construct",
    "app/widgets/ResourceRow",
    "app/widgets/FieldValidation",
    "dojo/request/xhr"
], function (
    declare,
    domConstruct,
    ResourceRow,
    validation,
    xhr
) {
    return declare("app/widgets/initiative/InitiativeRow",
            [ResourceRow], {

        title: null,
        _initI18n : function() {
            this.title = i18n("Initiative");
        },

        postCreate: function() {
            var _this = this;
            //only get the list of integration providers once
            if (!this.getCache("integrationProviders")) {
                xhr.get(uReleaseConfig.urls.base+"integrationProvider", {
                    headers: {
                        "Accept": "application/json"
                    },
                    handleAs: "json",
                    sync: true
                }).then(function(data) {
                    _this.putCache("integrationProviders", data);
                });
            }
            this.inherited(arguments);
        },

        /**
         *
         */
        getColumns: function() {
            var _this = this;
            _this.addFieldValidation("name", i18n("Name"), validation.maxLength(255));
            _this.addFieldValidation("description", i18n("Description"), validation.maxLength(4000));
            return [{
                "name": i18n("Name"),
                "width": "30%",
                'sortBy': 'name',
                "formatter": function() {
                    return domConstruct.create("a", {
                        "innerHTML": _this.model.getHTML('name'),
                        "href": uReleaseConfig.urls.base+"initiatives/"+_this.model.get("id")
                    });
                },
                "getValue": function() {
                    return _this.model.get("name");
                },
                "fieldData": {
                    "type": "Validation Text",
                    "name": "name",
                    "label": i18n("Name"),
                    "required": "true",
                    "placeHolder": i18n("Initiative Name"),
                    "missingMessage": i18n("A name is required"),
                    "readOnly": _this.isIntegratedFieldReadOnly("name")
                },
                'filterData': {
                    'type': 'Text',
                    'class': 'String',
                    'filterField': 'name'
                }
            },{
                "name": i18n("Description"),
                "width": "60%",
                'sortBy': 'description',
                "getValue": function() {
                    return _this.model.get("description");
                },
                "fieldData": {
                    "type": "Text",
                    "name": "description",
                    "label": i18n("Description"),
                    "placeHolder": i18n("Description of Initiative"),
                    "readOnly": _this.isIntegratedFieldReadOnly("description")
                },
                'filterData': {
                    'type': 'Text',
                    'class': 'String',
                    'filterField': 'description'
                }
            }];
        }
    });
});
