/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
define([
    "dojo/_base/declare",
    "app/widgets/initiative/ChangeRow",
    "app/widgets/CheckboxResourceRow",
    "app/model/release/ReleaseDeprecated",
    "app/model/application/Application",
    "app/model/ResourceRegistry",
    "js/webext/widgets/FilteringScrollSelect"
], function(
    declare,
    CheckboxResourceRow,
    ChangeRow,
    Release,
    Application,
    Registry,
    FilteringScrollSelect
) {
    return declare("app/widgets/initiative/CheckedChangeRow", [CheckboxResourceRow, ChangeRow], {

        title: null,
        _initI18n: function() {
            this.title = i18n("Change");
        },
        delegates: undefined,

        /**
         *
         */
        getColumns: function() {
            var _this = this;

            //Override the widths stored in this class before calling
            //to the parent class.
            this.widths = {
                // checkbox -> 30px because of mixin above.
                "type": "10%",
                "id": "6%",
                "name": "16%",
                "source": "8%",
                "status": "8%",
                "severity": "8%",
                "initiative": "13%",
                "release": "13%",
                "application": "13%"
            };

            //Store the columns from the interiance.
            var originalColumns = this.inherited(arguments);
            var columns = [];

            //Add in the columns from the inheritance
            columns = columns.concat(originalColumns);

            //Initiative
            columns.push({
                "name": i18n("Initiative"),
                "sortBy": "initiative.name",
                "width": _this.widths.initiative,
                "getValue": function() {
                    return !!_this.model.get("initiative") ?
                        !!_this.model.get("initiative").get ?
                        _this.model.get("initiative").get("name") : "notloaded" : i18n("-");
                },
                "fieldData": {
                    "label": i18n("Initiative"),
                    "getField": function() {
                        _this.initiativeSelect = new FilteringScrollSelect({
                            "name": "initiative",
                            "readOnly": _this.isIntegratedFieldReadOnly("initiative"),
                            "restUrl": uReleaseConfig.urls.base + "initiatives/name",
                            "storeType": "Memory",
                            "accept": "application/json",
                            "allowNone": true,
                            "value": !!_this.model.get("initiative") ? _this.model.get("initiative").get("id") : null
                        });
                        return _this.initiativeSelect;
                    }
                },
                "filterData": {
                    "type": "Text",
                    "filterField": "initiative.name"
                }
            });

            return columns;
        },


        //setChecked: function(value) {
        //var _this = this;
        //_this.checkBox.set("checked", value);
        //},

        showEdit: function() {
            this.inherited(arguments);
            var _this = this;

        },

        preSave: function() {
            this.inherited(arguments);

            if (this.model.get("status") === "-") {
                this.model.set("status", "");
            }
            if (this.model.get("type") === "-") {
                this.model.set("type", "");
            }

            var selectedRelease = this.releaseSelect.get("item");
            if (selectedRelease) {
                var newRelease = new Registry().get(Release, selectedRelease);
                this.model.set("release", newRelease);
            }

            var selectedApplication = this.applicationSelect.get("item");
            if (selectedApplication) {
                var newApplication = new Registry().get(Application, selectedApplication);
                this.model.set("application", newApplication);
            }

            var selectedInitiative = this.initiativeSelect.get("item");
            if (selectedInitiative) {
                var newInitiative = new Registry().get(Release, selectedInitiative);
                this.model.set("initiative", newInitiative);
            }
        }
    });
});
