/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
        "dojo/_base/declare",
        "dojo/dom-construct",
        "dojo/dom-class",
        "dojo/request/xhr",
        "app/widgets/ResourceRow",
        "app/widgets/FieldValidation",
        "app/widgets/icon/IconPicker"
], function (
        declare,
        domConstruct,
        domClass,
        xhr,
        ResourceRow,
        validation,
        IconPicker
) {
    return declare("app/widgets/initiative/ChangeTypeRow",
            [ResourceRow], {

        title: null,
        _initI18n : function() {
            this.title = i18n("Change Types");
        },

        /**
         *
         */
        getColumns: function() {
            var _this = this;
            _this.addFieldValidation("name", i18n("Name"), validation.maxLength(255));
            return [{
                "name": i18n("Name"),
                "width": "30%",
                "formatter": function() {
                    var type = _this.model.get("icon") || null;
                    _this.typeDiv = domConstruct.create("div");
                    domConstruct.create('div', {
                        className:"change-type-icon " + type
                    }, _this.typeDiv);
                    domConstruct.create('div', {
                        innerHTML: _this.model.getHTML("name"),
                        className:"change-type-name"
                    }, _this.typeDiv);
                    return _this.typeDiv;
                },
                "getValue": function() {
                    return _this.model.get("name");
                },
                "fieldData": {
                    "type": "Validation Text",
                    "name": "name",
                    "label": i18n("Name"),
                    "required": "true",
                    "placeHolder": i18n("Type Name"),
                    "missingMessage": i18n("A name is required")
                }
            }];
        },

        showExtraForm: function() {
            this.iconPicker = new IconPicker({
                value: this.model ? this.model.get("icon") : null,
                iconList: [
                    ["error", "warning", "small-feature", "task-check", "other-change", "network", "configuration", "repair"],
                    ["bug", "minor-bug", "feature", "task", "other", "server", "testing", "environment"],
                    ["multiple-bugs", "blocker", "large-feature", "story", "check-list", "database", "multiple-tests", "verify"],
                    ["fire", "star-feature", "multiple-features", "epic", "virtual-machine", "cloud", "balance", "gear"]
                ],
                iconMasterClass: "change-type-icon",
                colorRowList: ["red", "orange", "yellow", "green", "teal", "blue", "purple", "gray"]
            });
            domClass.add(this.iconPicker.domNode, "inline-block");
            this.createExtraFieldRow(
                this.iconPicker
            );
        },

        preSave: function() {
            this.model.set("icon", this.iconPicker.get("value"));
        }
    });
});
