/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*globals i18n,uReleaseConfig, define, document*/

define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/store/JsonRest",
    "app/widgets/ResourceRow",
    "app/widgets/FieldValidation",
    "dojo/dom-construct",
    "dojo/request/xhr",
    "js/webext/widgets/FilteringScrollSelect",
    "app/widgets/select/WebextSelectXhrMemory",
    "dijit/TooltipDialog",
    "dijit/popup",
    "dojo/on",
    "dojo/dom"
], function (
    declare,
    lang,
    JsonRest,
    ResourceRow,
    validation,
    domConstruct,
    xhr,
    FilteringScrollSelect,
    WebextSelectXhrMemory,
    TooltipDialog,
    popup,
    on,
    dom
) {
    return declare("app/widgets/initiative/ChangeRow",
            [ResourceRow], {

        title: null,
        _initI18n : function() {
            this.title = i18n("Change");
        },
        separator: "true",
        selectOnExpand: 4,
        widths: {
            "type": "6%",
            "id": "6%",
            "name": "18%",
            "source": "13%",
            "status": "10%",
            "severity": "10%",
            "release": "13%",
            "application": "13%"
        },
        postCreate: function() {
            var _this = this;
            //only get the list of integration providers once
            if (!this.getCache("integrationProviders")) {
                xhr.get(uReleaseConfig.urls.base+"integrationProvider/", {
                    headers: {
                        "Accept": "application/json"
                    },
                    handleAs: "json",
                    sync: true
                }).then(function(data) {
                    _this.putCache("integrationProviders", data);
                });
            }
            this.inherited(arguments);
        },
        /**
         *
         */
        getColumns: function() {
            var _this = this;
            _this.addFieldValidation("name", i18n("Name"), validation.maxLength(255));

            return [{
                "name": i18n("Type"),
                "width": _this.widths.type,
                "sortBy":"type.name",
                "formatter": lang.hitch(_this, _this._buildTypeCell),
                "fieldData": {
                    "getField": function() {
                        var type = _this.model.get("type");

                        _this.typeSelect = new FilteringScrollSelect({
                            "value": !!type ? type.get('id') : null,
                            "name": "typeId",
                            "formatDropDownLabel" : function (menuitem, item) {
                                var type = item.icon || null;
                                var name = item.name.escape() || null;
                                var typeDiv = domConstruct.create("div");
                                menuitem.innerHTML = "<div class=\"change-type-name\">" + name + "</span>";
                                domConstruct.create('div', {
                                    className:"change-type-icon " + type
                                }, menuitem, "first");

                            },
                            "url": uReleaseConfig.urls.base+"changeTypes/",
                            "storeType": "Memory",
                            "accept": "application/json",
                            "autoSelectFirst": true,
                            "readOnly": _this.isIntegratedFieldReadOnly("type"),
                            "required": true
                        });

                        return _this.typeSelect;
                    }
                },
                "filterData" : {
                    "type" : "Text",
                    "filterField" : "type.name"
                }
            },{
                "name": i18n("ID"),
                "width": _this.widths.id,
                "getValue": function() {
                    return !!_this.model.get("externalId") ? _this.model.get("externalId") : "-";
                },
                "filterData": {
                    // TODO reenable once we can sort server-side
                    "type" : "Text",
                    "filterField" : "externalId"
                }
            },{
                "name": i18n("Name"),
                "sortBy":"name",
                "width": _this.widths.name,
                "getValue": function() {
                    return _this.model.get("name");
                },
                "formatter": _this.model.get("externalId") ? function() {
                    var result = "";
                    if (_this.model.get("externalUrl")) {
                            result = domConstruct.create("a", {
                                "innerHTML": _this.model.getHTML("name"),
                                "href": _this.model.get("externalUrl"),
                                "target" : "_blank",
                                "id":"tooltip_"+_this.model.get("externalId")
                            });
                        var dialogURL = _this.model.get("externalUrl")+"?_mediaType=text%2Fhtml&_selector=smallHover&_context=web";
                        dialogURL += '#oslc-core-postMessage-1.0';
                        _this.iframe = document.createElement('iframe');
                        _this.iframe.title = _this.model.get("name");
                        _this.iframe.width = 550;
                        _this.iframe.height = 355;
                        _this.iframe.src = dialogURL;

                        var divIframe = domConstruct.create("div", {
                          className: "rtc-ui-dialog"
                        });

                        var divIframeTitle = domConstruct.create("h1", {
                            "innerHTML": _this.model.getHTML("name")
                        }, divIframe);

                        var divIframeView = domConstruct.create("a", {
                            "innerHTML": i18n("View work item"),
                            "href": _this.model.get("externalUrl"),
                            "target" : "_blank"
                        }, divIframe);

                        domConstruct.place(divIframeTitle, divIframe);
                        domConstruct.place(divIframeView, divIframe);
                        domConstruct.place(_this.iframe, divIframe);

                        var tip = new TooltipDialog({
                            content: divIframe,
                            onMouseLeave: function(){
                                popup.close(tip);
                            }
                        });

                        _this.own(on(result, "mouseover", function(){
                            popup.open({
                                popup: tip,
                                around: dom.byId("tooltip_"+_this.model.get("externalId"))
                            });
                        }));
                    }
                    else {
                        result = _this.model.get("name") ? _this.model.getHTML("name") : "";
                    }
                    return result;
                } : undefined,
                "fieldData": {
                    "type": "Validation Text",
                    "name": "name",
                    "label": i18n("Name"),
                    "required": "true",
                    "placeHolder": i18n("Change Name"),
                    "missingMessage": i18n("A name is required"),
                    "selectOnExpand": true,
                    "readOnly": _this.isIntegratedFieldReadOnly("name")
                },
                "filterData": {
                    "type" : "Text",
                    "class" : "String",
                    "orderByThis" : true,
                    "filterField" : "name"
                }
            },{
                "name": i18n("Source"),
                "width": _this.widths.source,
                "sortBy":"integrationProvider.name",
                "getValue": function() {
                    return !!_this.model.get("integrationProvider") ? _this.model.get("integrationProvider").get("name") : i18n("-");
                },
                "filterData": {
                    "type": "Text",
                    "filterField" : "integrationProvider.name"
                }
            },{
                "name": i18n("Status"),
                "width": _this.widths.status,
                "sortBy":"status",
                "getValue": function() {
                    return i18n(_this.model.get("status"));
                },
                "fieldData": {
                    "label": i18n("Status"),
                    "getField": function() {
                        xhr.get(uReleaseConfig.urls.base+"changes/statuses", {
                            headers: {
                                "Accept": "application/json"
                            },
                            handleAs: "json",
                            sync: true
                        }).then(function(data) {
                                var options = [{
                                    value: "",
                                    name: i18n("None"),
                                    id: 1
                                }];
                                var option = "";
                                var id = 2;
                                var selectedStatus = options[0];
                                var newOption;
                                for (option in data){
                                    if (data.hasOwnProperty(option)) {
                                        newOption = {
                                            value: option,
                                            name: i18n(option),
                                            id: id
                                        };
                                        if(option === _this.model.get("status")) {
                                            selectedStatus = newOption;
                                        }
                                        options.push(newOption);
                                        id++;
                                    }
                                }
                                _this.statusSelect = new FilteringScrollSelect({
                                    name: "status",
                                    readOnly: _this.isIntegratedFieldReadOnly("status"),
                                    options: options,
                                    value: selectedStatus.id
                                });
                        });
                        return _this.statusSelect;
                    }
                },
                "filterData": {
                    "type": "Text",
                    "filterField" : "status"
                }
            },{
                "name": i18n("Severity"),
                "width": _this.widths.severity,
                "getValue": function() {
                    var result = i18n(_this.model.get("severity")) || "";
                    if (result === "OTHER") {
                        result = i18n("Other");
                    }
                    return result;
                },
                'fieldData': {
                    'label': i18n('Severity'),
                    'name': 'severity',
                    'type': 'select',
                    'readOnly': _this.isIntegratedFieldReadOnly('severity'),
                    //values based on an enum defined in Change.java
                    'allowedValues': [
                    {
                        value: null,
                        label: i18n("None")
                    }, {
                        value: "S1",
                        label: i18n("S1")
                    }, {
                        value: "S2",
                        label: i18n("S2")
                    }, {
                        value: "OTHER",
                        label: i18n("Other")
                    }]
                },
                "filterData": {
                    "type": "Select",
                    "class": "Enum",
                    "filterField": "severity",
                    // TODO - create a rest endpoint instead of hardcoding these values
                    // Leave first value blank so it isn't selecting anything
                    'allowedValues': [
                        {'label' : i18n('Any'),
                         'value': 'ANY'},
                        {'label' : i18n('S1'),
                         'value' : 'S1'},
                        {'label' : i18n('S2'),
                         'value' : 'S2'},
                        {'label' : i18n('Other'),
                         'value' : 'OTHER'}]
                }
            },{
                "name": i18n("Release"),
                "width": _this.widths.release,
                "sortBy":"release.name",
                "getValue": function() {
                    return !!_this.model.get("release") ?
                       !!_this.model.get("release").get ?
                       _this.model.get("release").get("name") : "notloaded" : i18n("-");
                },
                "fieldData": {
                    "label": i18n("Release"),
                    "getField": function() {

                        var release = _this.model.get("release");

                        _this.releaseSelect = new WebextSelectXhrMemory({
                            "name":"release",
                            "target": uReleaseConfig.urls.base + "releases/editable/",
                            "value": !!release ? release.get("id") : null,
                            "accept": "application/json",
                            "defaultQuery": "",
                            "allowNone": true
                        });

                        return _this.releaseSelect;
                    }
                },
                "filterData": {
                    "type": "Text",
                    "filterField":"release.name"
                }
            },{
                "name": i18n("Application"),
                "sortBy":"application.name",
                "width": _this.widths.application,
                "getValue": function() {
                    return !!_this.model.get("application") ?
                       !!_this.model.get("application").get ?
                       _this.model.get("application").get("name") : "notloaded" : i18n("-");
                },
                "fieldData": {
                    "label": i18n("Application"),
                    "getField": function() {
                        _this.applicationSelect = new FilteringScrollSelect({
                            "name": "application",
                            "readOnly": _this.isIntegratedFieldReadOnly("application"),
                            "restUrl": uReleaseConfig.urls.base+"application/simple",
                            "storeType": "Memory",
                            "accept": "application/json",
                            "allowNone": true,
                            "value": !!_this.model.get("application") ? _this.model.get("application").get("id") : null
                        });
                        return _this.applicationSelect;
                    }
                },
                "filterData": {
                    "type": "Text",
                    "filterField" : "application.name"
                }
            }];
        },
        _buildTypeCell: function () {
            var type = this.model.get("type") || null;
            var typeName = type ? (type.name || type.get("name")) : i18n('No Type');
            this.typeDiv = domConstruct.create("div");
            if (!!type) {
                var typeIcon = type.icon || type.get("icon");
                domConstruct.create('div', {
                    className: "change-type-icon " + typeIcon
                }, this.typeDiv);
            }
            domConstruct.create('div', {
                className: "change-type-name",
                innerHTML: typeName
            }, this.typeDiv);
            return this.typeDiv;
        },

        showExtraForm: function() {
            this.createExtraFieldRow({
                label: i18n("Description"),
                name: "description",
                value: this.model.get("description"),
                type: "Text Area",
                readOnly: this.isIntegratedFieldReadOnly("description")
            });
        },

        preSave: function() {
            this.inherited(arguments);
            var initiative = this.model.getNearestParentByShortClass("Initiative");
            if (!!initiative) {
                this.model.set("initiative", initiative.get("id"));
            }
            var status = "";
            if (this.statusSelect.get('item')){
                status = this.statusSelect.get('item').value;
            }
            this.model.set("status", status);
            this.model.set("type", this.typeSelect.get('item'));
        },

        postSave: function() {
            this.model.parent.load();
            this.toggleExpanded();
        }
    });
});
