/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*globals define, uReleaseConfig, i18n */
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/dom-construct",
    "dojo/dom-class",
    "dojo/on",
    "dojo/json",
    "dojo/request/xhr",
    "dijit/form/Button",
    "js/webext/widgets/RestSelect",
    "js/webext/widgets/FormDelegates",
    "app/widgets/UReleaseWidget",
    "app/model/initiative/Change",
    "app/widgets/CheckboxResourceTable",
    "dijit/form/Form",
    "app/widgets/initiative/CheckedChangeRow",
    "js/webext/widgets/Table"
], function (
    declare,
    array,
    domConstruct,
    domClass,
    on,
    JSON,
    xhr,
    Button,
    RestSelect,
    Delegates,
    UReleaseWidget,
    Change,
    CheckboxResourceTable,
    Form,
    CheckedChangeRow
) {
    return declare("app/widgets/initiative/ChangePage",
            [UReleaseWidget], {
        templateString:
            "<div class='changes change-view'>" +
                "<div class='change-form'>" +
                    "<div data-dojo-attach-point=\"optionsFormAttach\">" +
                        "<div data-dojo-attach-point=\"optionsTitleAttach\" class=\"inline-block options option-title\"></div>"+
                        "<div data-dojo-attach-point=\"optionsAttach\" class=\"inline-block\" style=\"margin-right: 5px;\"></div>"+
                        "<div data-dojo-attach-point=\"optionsIndividualAttach\" class=\"inline-block options\"></div>"+
                        "<div data-dojo-attach-point=\"buttonAttach\" class=\"inline-block options\"></div>"+
                    "</div>" +
                "</div>" +
                "<div data-dojo-attach-point=\"tableAttach\"></div>" +
            "</div>",
        delegates: undefined,

        postCreate: function() {
            var _this = this;
            _this.options = [];

            var optionsIndividualContainer = domConstruct.create("div", {
                "class": "inlineBlock change-options"
            }, _this.optionsIndividualAttach);

            var optionsContainer = domConstruct.create("div", {
                "class": "inlineBlock change-options"
            }, _this.optionsAttach);

            this.optionsForm = new Form({}, _this.optionsFormAttach);
            var optionsButton = new Button({
                type: "submit",
                label: i18n("Update")
            });

            this.optionsForm.own(on(this.optionsForm, "submit", function() {
                _this._applyOptions(_this.options);
                return false;
            }));
            domClass.add(optionsButton.domNode, "optionsSubmit");

            var optionsIndividualSelect = new RestSelect({
                "restUrl": uReleaseConfig.urls.base + "initiatives/?format=name",
                "allowNone": true,
                "autoSelectFirst": true,
                "value": null,
                "name": "typeId",
                "getLabel": function(item) {
                    return item.name;
                },
                "getValue": function(item) {
                    return item.id;
                },
                "isValid": function(item) {
                    var hasEdit = item.hasEdit;
                    if (hasEdit === undefined || hasEdit === null) {
                        hasEdit = true;
                    }

                    // TODO: Rework this to use methods on a model instead of direct property testing
                    if (item.level === "COMPONENT" || item.level === "SUITE") {
                        hasEdit = false;
                    }

                    return hasEdit;
                },
                "style": {
                    "padding-right": "5px"
                },
                "className": "inlineBlock change-select-options"
            });

            if (!this.delegates) {
                this.delegates = new Delegates();
            }
            var delegate = this.delegates.getDelegate("Select");
            var optionsWidgetTypeSelect = delegate({
                "type": "Select",
                "name": "selectType",
                "onChange": function(/*value*/) {
                    // we want to use the new plural-form endpoints, but we have to keep the old
                    // singular form of the type name -- also, formatting should match restUrl above
                    optionsIndividualSelect.restUrl = uReleaseConfig.urls.base + this.getValue()+"s/?format=name";
                    optionsIndividualSelect._updateRestUrl();
                    optionsIndividualSelect.set("value", null);
                },
                "allowedValues": [
                    // Since initiatives/name is hard-coded into restUrl above, make sure that's first here
                    { "label": i18n("Initiative"), "value": "initiative" },
                    { "label": i18n("Release"), "value": "release" },
                    { "label": i18n("Application"), "value": "application" }
                ],
                "style": {
                    "class": "inlineBlock",
                    "padding-right": "15px"
                }
            });

            var optionsText = domConstruct.create("div", {
                "innerHTML" : i18n("Assign Selected To: "),
                "class": "inlineBlock",
                "style": {
                    "padding": "6px 10px 0 0"
                }
            }, this.optionsTitleAttach);

            optionsWidgetTypeSelect.placeAt(optionsContainer);
            _this.options.push(optionsWidgetTypeSelect);

            optionsIndividualSelect.placeAt(optionsIndividualContainer);
            _this.options.push(optionsIndividualSelect);
            optionsButton.placeAt(this.buttonAttach);

            // make changes page paginated.
            _this.model = new Change([]);
            _this.model.lastRefresh = null;
            _this.model.set('isPaginated', true);

            _this.changesTable = new CheckboxResourceTable({
                "model": _this.model,
                "widgetClass": CheckedChangeRow,
                // Select name field when creating a new change.
                "selectField": 5,
                "labelNode": _this.domNode.parentNode.parentNode.children[0].children[1],
                "newItemPlacement": "first"
            }).placeAt(_this.tableAttach);
        },

        _applyOptions: function(options) {
            var _this = this;
            var result = {};
            result.changes = [];
            if (options) {
                result.type = options[0].value;
                result.id = options[1].value;

                var i;
                for (i in _this.changesTable.checkedRows) {
                    if (_this.changesTable.checkedRows.hasOwnProperty(i) &&
                        _this.changesTable.checkedRows[i]) {
                        result.changes.push(i);
                    }
                }

                _this.changesTable.checkedRows = {};

                var xhrArgs = {
                    data: JSON.stringify(result),
                    headers: { "Content-Type": "application/json" }
                };
                _this.changesTable.filters[0].set("checked", false);

                var deferred = xhr.put(uReleaseConfig.urls.base+"changes/update", xhrArgs).then(function(data) {
                    _this.model.load();
                }, function (error) {
                    //XXX this should be a webext Alert, not a basic javascript alert.
                    alert(error.responseText);
                });
            }
        }
    });
});
