/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, require, uReleaseConfig, window*/
define([
    "dojo/_base/declare",
    "dojo/dom-construct",
    "app/widgets/icon/Icon"
], function(
    declare,
    domConstruct,
    Icon
) {
    return declare("app/widget/icon/TaskIcon", [Icon],{
        /**
         * expected to be an object with properties {x:Num, y:Num}
         */
        imageOffset: {
            x:"0",
            y:"-150px"
        },
        /**
         * the image that backs this icon
         */
        url:null,
        /**,
         * indicates the intended size of the image, if it is a retina image.
         */
        backgroundSize: null,
        /**
         * expected to be an object with properties {x:Num, y:Num}
         */
        dimensions: {
            x:"15px",
            y:"15px"
        },
        /**
         * type
         */
        type:"PLANNED",
        _setTypeAttr: function (value) {
            this.type = value;
            domConstruct.empty(this.contentAP);
        },
        postCreate:function () {
            this.url = uReleaseConfig.urls.staticContent + "images/sprites/task-icons.svg";
            this.backgroundSize = "30px 570px";


            if(typeof this.type === 'string') {
                this.type = this.type.toUpperCase();
            }
            switch(this.type) {
                case 'OPEN':
                case 'WAITING':
                    this.imageOffset = {
                        x:"0px",
                        y:"-60px"
                    };
                    break;
                case 'LATE':
                    this.imageOffset = {
                        x:"0px",
                        y:"0px"
                    };
                    break;
                case 'INPROGRESS':
                case 'EXECUTING':
                    this.imageOffset = {
                        x:"0px",
                        y:"-90px"
                    };
                    break;
                case 'SKIPPED':
                    this.imageOffset = {
                        x:"0px",
                        y:"-45px"
                    };
                    break;
                case 'NOTAPPLICABLE':
                    this.imageOffset = {
                        x:"0px",
                        y:"-75px"
                    };
                    break;
                case 'TOTAL':
                    this.imageOffset = {
                        x:"0px",
                        y:"-30px"
                    };
                    break;
                case 'COMPLETE':
                    this.imageOffset = {
                        x:"0px",
                        y:"-120px"
                    };
                    break;
                case 'NOTSTARTED':
                case 'PLANNED':
                    this.imageOffset = {
                        x:"0px",
                        y:"-15px"
                    };
                    break;
                default: // 'FAILED' 'FAILURE
                    this.imageOffset = {
                        x:"0px",
                        y:"-105px"
                    };
                    break;
            }
            this.inherited(arguments);
        }
    });
});
