/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, window*/
define([
    "dojo/_base/declare",
    "dojo/dom-class",
    "dojo/dom-style",
    "app/widgets/UReleaseWidget"
], function(
    declare,
    domClass,
    domStyle,
    _URWidget
) {
    return declare("app/widgets/icon/SeverityCountIcon", [_URWidget], {
        templateString:
            '<div class="severity-count-icon">' +
                '<div data-dojo-attach-point="badgeAP" class="badge"> </div>' +
                '<span data-dojo-attach-point="contentAP" class="content"></span>' +
            '</div>',
        count:null,
        postCreate: function () {
            this.contentAP.innerHTML = this.value;
            if(this.value > 0) {
                domClass.add(this.badgeAP, "red");
            } else {
                domClass.add(this.badgeAP, "green");
            }
            if (this.value > 99) {
                domStyle.set(this.contentAP, "font-size", "100%");
                domStyle.set(this.contentAP, "padding-top", ".75em");

            }
        }
    });
});
