/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, window*/
define(["dojo/_base/declare",
        "app/widgets/UReleaseWidget"],
function(declare, _URWidget) {
    return declare([_URWidget],{
        templateString:
        '<div style="display:inline-block;vertical-align: bottom"data-dojo-attach-point="contentAP"></div>',
        /**
         * expected to be an object with properties {x:Num, y:Num}
         */
        imageOffset: {
            x:"",
            y:""
        },
        /**
         * the image that backs this contentAP
         */
        url: null, //
        /**
         * expected to be an object with properties {x:Num, y:Num}
         */
        dimensions: null,
        postCreate: function() {
            this.inherited(arguments);
            this.contentAP.style.backgroundImage = "url('" + this.url + "')";
            this.contentAP.style.height = this.dimensions.y;
            this.contentAP.style.width = this.dimensions.x;
            this.contentAP.style.backgroundPosition =
                this.imageOffset.x + " " + this.imageOffset.y;
            if(this.backgroundSize) {
                this.contentAP.style.backgroundSize = this.backgroundSize;
            }
        },
        isRetina : function () {
            return window.devicePixelRatio > 1;
        }


    });
});
