/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, util, i18n */
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "app/widgets/UReleaseWidget",
    "dojo/text!app/widgets/filter/templates/FilterControl.html"
], function(
    declare,
    array,
    _URWidget,
    template
) {
    /**
     * FilterControl
     *
     * description:  FilterControl is a widget that
     *
     */
    return declare("app/widgets/filter/FilterControl", [_URWidget],{

        /**
         * whether the filter should only accept a single filter at a time (radio button style)
         */
        singleFilter: false,

        /**
         * add a new item on the page to be used as one of this widgets filters
         */
        addFilter: function (filterProperty, selectDom) {

        },

        /**
         * remove an existing filter
         */
        removeFilter: function (filterProperty) {

        },


        /********************************************************************************
         * PRIVATE PROPERTIES AND METHODS
         ********************************************************************************/

        /**
         *
         */
        postCreate: function() {
            this.inherited(arguments);
            this._initialize();
        },

       /**
        * template for the widget
        */
        templateString:template,

        /**
         * the list of filters that this widget tracks
         */
        _filters:null,

        /**
         * initialize the widget
         */
        _initialize: function () {
            array.forEach([]);
        },

        /**
         * prepare all filters that are defined within the widget's own
         */
        _initializeFilters: function () {

        },

        /**
         *
         */
        _initializeFilter: function () {

        }

    });
});
