/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

/*global define */
define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "dojo/dom-class",
    "dijit/form/Button",
    "app/widgets/UReleaseWidget"
], function(
    declare,
    lang,
    domConstruct,
    domClass,
    Button,
    _URWidget
) {
    return declare("app/widgets/button/DeleteConfirmButton", [_URWidget],{
        templateString:
            '<div data-dojo-attach-point="contentAP">' +
                '<div data-dojo-attach-point="primaryAP"></div>' +
                '<div data-dojo-attach-point="secondaryAP" class="hidden">' +
                '<fieldset style="margin-top: -12px;border:1px solid lightgray" data-dojo-attach-point="fieldsetAP">' +
                    '<legend style="font-weight:bold;text-align:center">Delete?</legend>' +
               '</fieldset>' +
                '</div>' +
            '</div>',
        buildRendering: function () {
            this.primaryButton = new Button({
                label: this.label || i18n("Delete"),
                onClick: lang.hitch(this, this.showSecondary)
            });
            this.secondaryConfirm = new Button({
                label: i18n("Confirm"),
                onClick: lang.hitch(this, this.confirm)
            });
            domClass.add(this.secondaryConfirm, "dangerButton");
            this.secondaryCancel = new Button({
                label: i18n("Cancel"),
                onClick: lang.hitch(this, this.showPrimary)
            });
            this.inherited(arguments);
        },
        postCreate: function() {
            domConstruct.place(this.primaryButton.domNode, this.primaryAP);
            domConstruct.place(this.secondaryCancel.domNode, this.fieldsetAP);
            domConstruct.place(this.secondaryConfirm.domNode, this.fieldsetAP);
        },
        _setLabelAttr : function (val) {
            this.primaryButton.set('label', val);
        },
        _getLabelAttr : function () {
            return this.primaryButton.get('label');
        },
        confirm: function () {
            //this.resource.remove();
        },
        showSecondary: function () {
            domClass.add(this.primaryAP, "hidden");
            domClass.remove(this.secondaryAP, "hidden");
        },
        showPrimary: function () {
            domClass.remove(this.primaryAP, "hidden");
            domClass.add(this.secondaryAP, "hidden");
        }
    });
});
