/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global bootstrap, define, i18n, util, uReleaseConfig */
define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/request/iframe",
    "dijit/form/Button",
    "dijit/form/TextBox",
    "js/webext/widgets/Alert",
    "js/webext/widgets/FieldList",
    "js/webext/widgets/Dialog",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin"
], function(
    declare,
    lang,
    domConstruct,
    on,
    iframe,
    Button,
    TextBox,
    Alert,
    FieldList,
    Dialog,
    Widget,
    TemplatedMixin
) {

    /**********************************
     * Private Properties and Methods
     **********************************/
    var buildHeaders = function () {
        var header = {};
        if (!!bootstrap) {
             var apiTokenName = bootstrap.apiTokenName || bootstrap.expectedSessionCookieName;
             if (apiTokenName) {
                 var apiToken = util.getCookie(apiTokenName);
                 if (!!apiToken) {
                     header[apiTokenName] = apiToken;
                 }
             }
         }
        return header;
    };

    /**********************************
     * END Private Properties and Methods
     **********************************/

    return declare("app/widgets/UploaderWidget", [Widget, TemplatedMixin], {
        /**
         * A base class for a widget that will upload a file with a description field both of which
         * are displayed in a dialog box that appears upon instantiation of this object.  It sends
         * a POST request to the destination specified.  It also prompts the update of its parent
         * model.
         *
         * Back-End Controller:
         *
         *         Receiving POST Data:
         *             @FormParam("description") String description,
         *             @FormParam("modelID") String vsID,
         *             @FormParam("userID") String userID,
         *             @FormParam("file") InputStream uploadedInputStream,
         *             @FormParam("file") FormDataContentDisposition fileDetail)
         *
         *
         * Expects properties:
         *  {
         *      parent: the containing widget (MUST CONTAIN model)
         *      path: (string) the request destination after the base URL
         *      onUpload: (optional Function) this is the function from the parent
         *              that will be called upon the successful upload and it is called
         *              within the parent's scope, using lang.hitch
         *  }
         *
         *
         */
        templateString: "<div></div>",
        
        uploadFieldOnly: false,
        
        instructions: "",
        
        title: null,

        postCreate : function() {

            var _this = this;
            var onUpload = lang.hitch(_this.parent, _this.onUpload);

            this.dialog = new Dialog();

            this.dialogOptionAttach = domConstruct.create("div", {
                "style" : "margin-bottom:15px"
            });
            this.dialogFormAttach = domConstruct.create("div");


            /*
             *
             * Dialog box contents
             *
             */
            
            if (this.title) {
                domConstruct.create("div", {
                    innerHTML: this.title
                }, this.dialog.titleNode);
            }

            var defaultName = "";
            if(this.form && this.form.getValue("name")) {
                defaultName = this.form.getValue("name");
            }
            domConstruct.empty(this.dialogFormAttach);

            var newUrl = uReleaseConfig.urls.base + this.path;
            var form = domConstruct.create("form", {
                "action" : newUrl,
                "enctype" : "multipart/form-data",
                "method" : "POST",
                "name" : "importForm",
                "id" : "importForm"
            }, this.dialogFormAttach);

            var fieldList = new FieldList();
            fieldList.placeAt(form);

            if (!this.uploadFieldOnly) {
                this.descriptionInput = new TextBox({
                    "name" : "description",
                    "value": defaultName
                });
                fieldList.insertDomNode(i18n("Description"), this.descriptionInput.domNode);
            }
            var instructionsDiv = domConstruct.create("div", {});
            fieldList.insertDomNode(this.instructions, instructionsDiv);

            var uploader = domConstruct.create("input", {
                "type" : "file",
                "name" : "file"
            });
            fieldList.insertDomNode(i18n("File"), uploader);

            domConstruct.create("input", {
                "type" : "hidden",
                "value" : this.parent.model.get("id"),
                "name" : "modelID"
            }, form);

            var fileName = domConstruct.create("input", {
                "type" : "hidden",
                "value" : "",
                "name" : "fileName"
            }, form);

            domConstruct.create("input", {
                "type" : "hidden",
                "value" : uReleaseConfig.user.id,
                "name" : "userID"
            }, form);

            var buttonContainer = domConstruct.create("div");
            var saveButton = new Button({
                "label" : i18n("Save")
            });
            on(saveButton, "click", function() {
                if (uploader.value) {
                    var value = uploader.value.split(/[\/\\]/).pop();
                    fileName.value = value;
                    iframe(newUrl, {
                        form : form,
                        handleAs : "html",
                        query:buildHeaders()
                    }).then(
                        function() {
                            _this.parent.model.load().then(function(){
                                try{
                                    onUpload();
                                } catch(ignore) {
                                }
                            });

                            _this.dialog.hide();
                            _this.dialog.destroy();
                            _this.destroy();

                        },
                        function() {

                            var importAlert = new Alert({
                                message : i18n("Error uploading file.")
                            });
                        }
                    );
                } else {
                    var importAlert = new Alert({
                        title: i18n("Error"),
                        message: i18n("Please select a file to upload")
                    });
                }
            });
            saveButton.placeAt(buttonContainer);

            var cancelButton = new Button({
                "label" : i18n("Cancel")
            });
            on(cancelButton, "click", function() {
                _this.dialog.hide();
                _this.dialog.destroy();
                _this.destroy();
            });
            cancelButton.placeAt(buttonContainer);

            fieldList.insertDomNode("", buttonContainer);

            domConstruct.place(this.dialogFormAttach, _this.dialog.containerNode);

            this.dialog.show();
        }
    });
});
