define([
  "dojo/_base/declare",
  "dojo/fx/Toggler",
  "dojo/fx",
  "dojo/dom-construct",
  "app/widgets/UReleaseWidget",
  "dojo/dom-style",
  "dojo/dom-geometry"
], function (
      declare,
      Toggler,
      coreFx,
      domConstruct,
      UReleaseWidget,
      domStyle,
      domGeom
) {

  return declare("app/widgets/ToggleDiv", [UReleaseWidget], {

    templateString:
    '<div class="expand-container" data-dojo-attach-point="expandParent">' +
        '<div data-dojo-attach-point="toggleTab" class="toggle-tab">'+
        '<div class="toggle-tab-filler" ></div>'+
        '</div>' +
        '<div class="expand-header" data-dojo-attach-point="headerDiv"></div>' +
        '<div class="expand-content" data-dojo-attach-point="contentDiv"></div>' +
    '</div>',

      toggleElement: null,

      isOpen: false,

      title: null,

      content: null,

      toggleId: 0,

      activeToggleId: -1,

      initToggleId: -1,

      relatedDeployment: null,

      parent: null,

      postCreate: function() {
        var _this = this;
        this.inherited(arguments);

        _this.title = this.title || '';
        _this.content = this.content || '';
        var toggleController = this.parent.detailsAP;

        _this.toggleElement = new Toggler({
          node: toggleController,
          showFunc: coreFx.wipeIn,
          hideFunc: coreFx.wipeOut
        });
        dojo.place(this.expandParent, toggleController);
      },
      trigger: function (triggerParameters) {
          var _this = this;
          var toggleId = triggerParameters.toggleId;
          var contentNode = triggerParameters.contentNode;
          var titleNode = triggerParameters.titleNode;
          var leftPostion = triggerParameters.leftPostion;
          var dataExtension = triggerParameters.dataExtension;
          var result;
          function generateViewMoreLink(url) {
              var seeMoreContainer = domConstruct.create("div",{
                  "class":"toggle-div-see-more-container"
              });
              var seeMoreTextContainer = domConstruct.create("div",{
                  "class":"toggle-div-see-more-text-container"
              }, seeMoreContainer);

              var seeMoreText = domConstruct.create("a",{
                  "class":"toggle-div-see-more-text"
              }, seeMoreTextContainer);
              seeMoreText.innerHTML = i18n("View more");
              if(!!_this.currentScheduledDeployment) {
                  seeMoreText.href = uReleaseConfig.urls.base+"scheduledDeployment/" + _this.currentScheduledDeployment.get("id")+"/"+url;
              } else {
                  seeMoreText.href = uReleaseConfig.urls.base+"relatedDeployments/" + _this.relatedDeployment.get("id")+"/"+url;
              }

              seeMoreText.target = "_blank";
              _this.contentDiv.appendChild(seeMoreContainer);
          }
          if(toggleId !== _this.activeToggleId) {
              result = true;
              _this.setContent(contentNode);
              _this.setTitle(titleNode);
              _this.expandDiv();
              _this.activeToggleId = Number(toggleId);
          } else {
              result = false;
              _this.collapseDiv();
              _this.activeToggleId = Number(_this.initToggleId);
          }
          if(!!dataExtension) {
              if(!!dataExtension.isActive) {
                  generateViewMoreLink(dataExtension.url);
              }
          }
          var tabPosition = domGeom.position(_this.toggleTab);
          var tabLeftPosition = "calc(20% - "+tabPosition.w/2+"px)";
          if(!!leftPostion) {//calculates the new tab position
              if(typeof leftPostion !== "number") {
                  throw "Invalid tab toggle position provided";
              }
              var parentPosition = domGeom.position(_this.toggleTab.parentNode);
              var minPercent = 0;
              var maxPercent = 100 - ((tabPosition.w / parentPosition.w) * 100);
              var parentDomRelative = ((leftPostion - parentPosition.x) - (tabPosition.w/2));
              tabLeftPosition = (parentDomRelative/parentPosition.w) * 100;
              if(tabLeftPosition < 0) {
                  tabLeftPosition = minPercent;
              }
              if(tabLeftPosition > maxPercent) {
                  tabLeftPosition = maxPercent;
              }
              tabLeftPosition = tabLeftPosition+"%";
          }

          domStyle.set(_this.toggleTab, "left", tabLeftPosition);//set left style css
          return result;
      },
      expandDiv: function() {
        var _this = this;
        if(!this.isOpen) {
            this.toggleElement.show();
        }
        this.isOpen = true;
        return _this.enroll();
      },
      enroll: function() {
        var _this = this;
          return _this.toggleId++;
      },
      collapseDiv: function() {
        this.toggleElement.hide();
        this.contentDiv.innerHTML = "";
         this.isOpen = false;
      },

      /**
       * Used to set the data content
       */
      setContent: function(value) {
        this.contentDiv.innerHTML = "";
        var toggleContentWrapper = domConstruct.create("div", {"class":"toggle-content-wrapper"});
        toggleContentWrapper.appendChild(value);
        this.contentDiv.appendChild(toggleContentWrapper);
      },

      /**
       * Used to set the detail header
       */
      setTitle: function(value) {
        this.headerDiv.innerHTML = "";
        this.headerDiv.appendChild(value);
      }
  });
});
