/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define */
define(["dojo/_base/declare",
        "dojo/dom-construct",
        "app/widgets/UReleaseWidget"],
function(declare, domConstruct, _URWidget) {
    return declare("app/widgets/TextIcon",[_URWidget],{
        templateString:
            '<div class="text-icon inline-block">' +
                '<div class="inlineBlock" data-dojo-attach-point="firstAP"></div>' +
                '<div class="inlineBlock" data-dojo-attach-point="lastAP"></div>' +
            '</div>',
        postCreate: function() {
            var iconPos = 'first',
                labelPos = 'last';
            this.inherited(arguments);

            if (this.position ==='last') {
                iconPos = 'last';
                labelPos = 'first';
            }

            if(this.icon) {
                this.icon.placeAt(this[iconPos+"AP"]);
            }

            if(this.label) {
                domConstruct.create("span",{
                    "innerHTML": this.label || i18n("No Status"),
                    "style": {
                        //"height": this.icon ? this.icon.dimensions.y : ""
                        //"margin": this.icon ? "-15% 0 0;" : ""
                    }
                },this[labelPos+"AP"]);
                if(this.icon) {
                    this[labelPos+"AP"].style.height = this.icon ? this.icon.dimensions.y : "";
                    this[labelPos+"AP"].style.marginTop = "-6%";

                    var margin = iconPos === 'last' ? "marginLeft" : "marginRight";
                    this[iconPos+"AP"].style[margin] = "5px";
                }
            }
        }
    });
});
