define([
  "dojo/_base/declare",
  "dojo/fx/Toggler",
  "dojo/fx",
  "dojo/dom-construct",
  "app/widgets/UReleaseWidget",
  "dojo/dom-class",
  "app/widgets/TaskStatusCountWidget",
  "app/model/relatedDeployment/RelatedDeploymentTask",
  "dojo/io-query",
  "dojo/_base/array",
  "dojo/store/JsonRest"
], function (
      declare,
      Toggler,
      coreFx,
      domConstruct,
      UReleaseWidget,
      domClass,
      TaskStatusCountWidget,
      RelatedDeploymentTask,
      ioQuery,
      array,
      JsonRest
) {
    return declare("app/widgets/TaskStatusWidget", [UReleaseWidget], {
        relatedDeployment: null,//holds related deployment to which the widget is associated
        widgets: {},//map of status to respective task count widget.
        toggle: null,//toggle div object
        //The current scheduled deployment if loaded from Scheduled Deployment Page
        currentScheduledDeployment: null,

        postCreate: function () {
            var _this = this;
            _this.inherited(arguments);
            domClass.add(_this.domNode, "task-status-widget");
            this.useStandby();
        },
        load: function() {
            var _this = this;
            _this._initializeWidgets();
        },
        _initializeWidgets: function () {
            var _this = this;
            _this._getData();
        },
        _refresh: function () {
            var _this = this;
        },
        /**
         * function gets the data for the task status widget using rest end point
         */
        _getData: function() {
            var _this = this;
            var url;
            if (!_this.currentScheduledDeployment) {
                url = uReleaseConfig.urls.base+"relatedDeployments/"+_this.relatedDeployment.get("id")+"/taskStatusCountWidget";
            }
            else {
                url = uReleaseConfig.urls.base+"scheduledDeployments/"+_this.currentScheduledDeployment.get("id")+"/taskStatusCountWidget";
            }
            
            var xhrArgs = {
                url: url,
                handleAs: "json",
                preventCache: true,
                load: function(data){
                  _this._formatData(data);
                }
            };
            var deferred = dojo.xhrGet(xhrArgs);
            _this.standby.show();
            deferred.then(function() {
                _this.standby.hide();
            });
        },
        /**
         * Method that builds a query using an array of parameters
         */
        buildQueryParameters: function (restEndPoint, title, requestParameters) {

            var paramDictionary = {};
            var filterFields = [];

            array.forEach(requestParameters, function(parameter){
                var parameterkey;
                for(parameterkey in parameter) {
                    if (parameter.hasOwnProperty(parameterkey)) {
                        var urlParamKey = parameterkey;
                        var urlParamvalue = parameter[parameterkey];
                        if (urlParamKey !== "filterFields") {
                            paramDictionary[urlParamKey+"_"+parameter.filterFields] = urlParamvalue;
                        }
                        else {
                            filterFields.push(parameter.filterFields);
                        }
                    }
                }
            });

            paramDictionary.filterTitle = title;
            paramDictionary.restEndPoint = restEndPoint;
            paramDictionary.filterFields = filterFields;

            return ioQuery.objectToQuery(paramDictionary);
        },
        /**
         * Formats data by classifying them into unclaimed and late statuses. Populates the _this.widget object.
         */
        _formatData: function(data) {
            var _this = this;
            var status;

            /**
             * Instantiates the task status count object for both the late and task count options.
             */
            var queryStr;
            var field;
            var parameters;
            var toggleExternalLink;
            var rowModel;
            var modelUri;
            var isApplicable;


            parameters = {};
            isApplicable = {};
            isApplicable.filterFields = "isApplicable";
            isApplicable.filterType = "eq";
            isApplicable.filterClass = "Boolean";
            isApplicable.filterValue = "true";

            field = parameters.filterFields;
            parameters.restEndPoint = "lateTasks";
            queryStr = _this.buildQueryParameters ("lateTasks", i18n("Late tasks"), [parameters, isApplicable]);
            toggleExternalLink ="moreTasks?"+ queryStr;
            if (!_this.currentScheduledDeployment) {
                modelUri = uReleaseConfig.urls.base+"relatedDeployments/"+_this.relatedDeployment.get("id")+"/lateTasks";
            }
            else {
                modelUri = uReleaseConfig.urls.base+"scheduledDeployments/"+_this.currentScheduledDeployment.get("id")+"/lateTasks";
            }
            rowModel = new RelatedDeploymentTask();
            rowModel.filter({
                "field":"isApplicable",
                "type":"eq",
                "class":"Boolean",
                'value': "true"
            });

            rowModel.setResourceUrl(modelUri);
            rowModel.store = new JsonRest({
                target: rowModel.getResourcePath(),
                headers:{"Accept":"application/json"}
            });

            rowModel.format = "detail";
            rowModel.set('isPaginated', true);
            var lateStatusCountWidget = new TaskStatusCountWidget({
                status: i18n("Late Tasks"),
                circleClass: "late-task-status-count",
                count: data.late,
                rowModel: rowModel,
                toggle: _this.toggle,
                toggleExternalLink: toggleExternalLink,
                parentWidget: _this
            });
            _this.widgets.late = lateStatusCountWidget;
            _this.domNode.appendChild(lateStatusCountWidget.domNode);



            var manualParams = {};
            manualParams.filterFields = "taskTypeModuleClassName";
            manualParams.filterType = "eq";
            manualParams.filterClass = "Enum";
            manualParams.filterValue = "ManualTask";
            parameters = {};
            parameters.filterFields = "assignedUser.id";
            parameters.filterType = "null";
            parameters.filterClass = "String";
            parameters.filterTitle = i18n("Unclaimed Task");

            isApplicable = {};
            isApplicable.filterFields = "isApplicable";
            isApplicable.filterType = "eq";
            isApplicable.filterClass = "Boolean";
            isApplicable.filterValue = "true";

            field = parameters.filterFields;
            parameters.restEndPoint = "tasks";
            queryStr = _this.buildQueryParameters ("tasks", i18n("Unclaimed tasks"), [parameters, manualParams, isApplicable]);
            toggleExternalLink ="moreTasks?"+ queryStr;

            if (!_this.currentScheduledDeployment) {
                modelUri = uReleaseConfig.urls.base+"relatedDeployments/"+_this.relatedDeployment.get("id")+"/tasks";
            }
            else {
                modelUri = uReleaseConfig.urls.base+"scheduledDeployments/"+_this.currentScheduledDeployment.get("id")+"/tasks";
            }
            rowModel = new RelatedDeploymentTask();
            rowModel.filter({
                "field":"assignedUser.id",
                "type":"null",
                "class":"String",
                "value":"null",
                'locked': true
            });
            rowModel.filter({
                "field":"taskTypeModuleClassName",
                "type":"eq",
                "class":"Enum",
                'locked': true,
                "value": "ManualTask"
            });
            rowModel.filter({
                "field":"isApplicable",
                "type":"eq",
                "class":"Boolean",
                'value': "true"
            });
            rowModel.setResourceUrl(modelUri);
            rowModel.store = new JsonRest({
                target: rowModel.getResourcePath(),
                headers:{"Accept":"application/json"}
            });

            rowModel.format = "detail";
            rowModel.set('isPaginated', true);
            var unclaimedStatusCountWidget = new TaskStatusCountWidget({
                status: i18n("Unclaimed Tasks"),
                circleClass: "unclaimed-task-status-count",
                count: data.unclaimed,
                toggle: _this.toggle,
                rowModel: rowModel,
                toggleExternalLink: toggleExternalLink,
                parentWidget: _this
            });
            _this.widgets.unclaimed = unclaimedStatusCountWidget;
            _this.domNode.appendChild(unclaimedStatusCountWidget.domNode);



            parameters = {};
            parameters.filterFields = "status";
            parameters.filterType = "eq";
            parameters.filterClass = "Enum";
            parameters.filterValue = "OPEN";
            parameters.filterTitle = i18n("Waiting tasks");

            isApplicable = {};
            isApplicable.filterFields = "isApplicable";
            isApplicable.filterType = "eq";
            isApplicable.filterClass = "Boolean";
            isApplicable.filterValue = "true";
            field = parameters.filterFields;
            parameters.restEndPoint = "tasks";
            queryStr = _this.buildQueryParameters ("tasks", i18n("Waiting tasks"), [parameters, isApplicable]);
            toggleExternalLink ="moreTasks?"+ queryStr;
            if (!_this.currentScheduledDeployment) {
                modelUri = uReleaseConfig.urls.base+"relatedDeployments/"+_this.relatedDeployment.get("id")+"/tasks";
            }
            else {
                modelUri = uReleaseConfig.urls.base+"scheduledDeployments/"+_this.currentScheduledDeployment.get("id")+"/tasks";
            }
            rowModel = new RelatedDeploymentTask();
            rowModel.filter({
                "field":"status",
                "type":"eq",
                "class":"Enum",
                'locked': true,
                "value": "OPEN"
            });
            rowModel.filter({
                "field":"isApplicable",
                "type":"eq",
                "class":"Boolean",
                'value': "true"
            });
            rowModel.setResourceUrl(modelUri);
            rowModel.store = new JsonRest({
                target: rowModel.getResourcePath(),
                headers:{"Accept":"application/json"}
            });

            rowModel.format = "detail";
            rowModel.set('isPaginated', true);
            var openStatusCountWidget = new TaskStatusCountWidget({
                status: i18n("Waiting Tasks"),
                circleClass: "waiting-task-status-count",
                count: data.waiting,
                toggle: _this.toggle,
                rowModel: rowModel,
                toggleExternalLink: toggleExternalLink,
                parentWidget: _this
            });
            _this.widgets.waiting = openStatusCountWidget;
            _this.domNode.appendChild(openStatusCountWidget.domNode);

        }
    });
});
