define([
  "dojo/_base/declare",
  "dojo/fx/Toggler",
  "dojo/fx",
  "dojo/dom-construct",
  "dojo/on",
  "app/widgets/UReleaseWidget",
  "dojo/dom-class",
  "app/model/ResourceRegistry",
  "dojo/_base/array",
  "app/widgets/task/RelatedDeploymentTaskRow",
  "app/widgets/ResourceTable",
  "dojo/dom-geometry"
], function (
      declare,
      Toggler,
      coreFx,
      domConstruct,
      on,
      UReleaseWidget,
      domClass,
      Registry,
      array,
      RelatedDeploymentTaskRow,
      ResourceTable,
      domGeom
) {

return declare("app/widgets/TaskStatusCountWidget", [UReleaseWidget], {
    templateString: '<div>' +
                        '<div data-dojo-attach-point="uiContainer" class="task-status-count-widget-ui-Container">' +
                            '<div data-dojo-attach-point="circleContainer" class="task-status-count-widget-circle-container">'+
                                '<div data-dojo-attach-point="circle" class="task-status-count-widget-circle">'+
                                '</div>'+
                            '</div>'+
                            '<div data-dojo-attach-point="taskStatusCountRectangleContainer" class="task-status-count-widget-rectangle-container">'+
                            '</div>'+
                        '</div>'+
                    '</div>',
        relatedDeployment: null,
        status: null,
        count: 0,
        toggle: null,
        toggleId: null,
        taskTable: null,
        circleClass: null,
        rowModel: null,
        postCreate: function () {
            var _this = this;
            _this.inherited(arguments);
            domClass.add(_this.domNode, "task-status-count-widget");
            _this._createUIWidget();
            _this.toggleId = _this.toggle.enroll();
            _this.own(on(this.domNode, "click", function(){
                         _this.parentWidget.useStandby();
                         _this.parentWidget.standby.show();
                         _this._drawTasks(_this.data);
                         _this.parentWidget.standby.hide();
                      })
                   );
        },
         _updateCircleCount: function (count) {
             var _this= this;
             _this.count = count;
             if (_this.count > 999) {
                domClass.add(_this.circle, "task-status-count-widget-circle-long");
            }
            else {
                domClass.remove(_this.circle, "task-status-count-widget-circle-long");
            }
            _this.circle.innerHTML = _this.count;
         },
        toggleExternalLink: null,
        /**
         * Creates the dom element of the tasks status count widget.
         */
        _createUIWidget: function () {
            var _this = this;
            /**
             * Adds the classes that are relevant to each task event status
             * @param dom - rectangle DOM element to which the status class is be associated.
             * @param status - status text got the task status count widget.
             * @author jbiotid
             */
            var uiContainer = _this.uiContainer;
            var circleContainer = _this.circleContainer;
            var circle = _this.circle;
            _this._updateCircleCount(_this.count);
            domClass.add(circleContainer, _this.circleClass);
            var rectangleContainer = _this.taskStatusCountRectangleContainer; 
            //Already translated when passed to that widget
            rectangleContainer.innerHTML = _this.status;
        },
        /**
         * Updates the widget with the new data elements.
         * @param data - collection of new data for status widget. It has to be a dojo based model object.
         */
        _update: function (data) {
            var _this = this;
            domConstruct.empty(_this.taskTable.domNode);
            _this.data = data;
        },
        _drawTasks: function () {
            var _this = this;

            if(!_this.rowModel) {//checks if the task icon widget has the widget set
                return;
            }
            var contentNode =  domConstruct.create("div",
                {
                    "class": "task-status-count-toggle-content-container"
                }
            );
            var titleNode = domConstruct.create("span",{
                "class": "task-status-count-widget-title-node",
                "innerHTML": _this.status
            });
            var position = domGeom.position(_this.domNode); 
            var leftPxPosition = position.x + (position.w/4);//gets desired position of tab head
            var toggleParams = {};
            if(_this.count>10) {
                var toggleOptions = null;
                if(!!_this.toggleExternalLink) {
                    toggleOptions = {isActive: true, url: _this.toggleExternalLink};
                    toggleParams.toggleId = _this.toggleId;
                    toggleParams.contentNode = contentNode;
                    toggleParams.titleNode = titleNode;
                    toggleParams.leftPostion = leftPxPosition;
                    toggleParams.dataExtension = toggleOptions;
                }
            }
            else {
                    toggleParams.toggleId = _this.toggleId;
                    toggleParams.contentNode = contentNode;
                    toggleParams.titleNode = titleNode;
                    toggleParams.leftPostion = leftPxPosition;
            }

            var isOpen = _this.toggle.trigger(toggleParams);

            if(isOpen) {
                _this.tempContainer = domConstruct.create("div",
                {
                    "class": "task-status-count-widget-content-node"
                }, _this.toggle.contentDiv);

                //create a temporary widget to add a spinner to in the task status drop down
                _this.tempWidget = new UReleaseWidget({
                    style: "height: 50px; width: 100%;"
                });

                _this.tempContainer.appendChild(_this.tempWidget.domNode);

                //show the spinner on the drop down
                _this.tempWidget.useStandby();
                _this.tempWidget.standby.show();

                //show the spinner on the task status widget
                _this.useStandby();
                _this.standby.show();
                    _this.taskTable = new ResourceTable({
                        widgetClass:RelatedDeploymentTaskRow,
                        model: _this.rowModel,
                        addLabel:null,
                        afterLoad: function() {
                            //hide both spinners and  destroy the temporary widget
                            _this.standby.hide();
                            _this.tempWidget.standby.hide();
                            domConstruct.destroy(_this.tempContainer);
                            var retrievedCount = _this.rowModel._getTotalRecordsAttr();
                            _this._updateCircleCount(retrievedCount);
                        }
                    });
                    domClass.add(_this.taskTable.domNode, "task-status-count-widget-content-node");
                    contentNode.appendChild(_this.taskTable.domNode);
            }
        },

        /**
         * creates the status text for the widget. This text is to be shown on the task status count web UI.
         */
        _getStatusText: function (status) {
            var statusText = status;
            if(typeof statusText === 'string') {
                switch(statusText.toUpperCase()) {
                    case "INPROGRESS":
                    case "EXECUTING":
                        statusText = "IN PROGRESS";
                    break;
                    case "OPEN":
                        statusText = "WAITING";
                    break;
                    default:
                    break;
                }
            
            
                statusText = statusText.toLowerCase();
                statusText = statusText.charAt(0).toUpperCase() + statusText.substring(1, statusText.length);
            }
            return statusText;
        },

        destroy: function() {
            var _this = this;
            domConstruct.empty(_this.taskTable.domNode);
            this.inherited(arguments);
        }
    });
});