/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*globals define, i18n, util, dijit*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/html",
    "dojo/on",
    "dojo/hash",
    "dojo/topic",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/query",
    "app/widgets/TabManager"
], function (
    declare,
    array,
    html,
    on,
    hash,
    topic,
    domClass,
    domConstruct,
    query,
    TabManager
) {
        /**
         * a Tab Widget for showing and loading tabbed information on a page.
         * Expects properties:
         *  {
                defaultTab : "string" // <== OPTIONAL
         *      configuration: [
         *          {
         *              hash: "string",
         *              label: "string"
         *              populate: function (tabDomNode) {
         *                  new Widget().placeAt(tabDomNode)
         *              },
         *          },{
         *              hash: "string2",
         *              label: "string2"
         *              populate: function (tabDomNode) {
         *                  new Widget().placeAt(tabDomNode)
         *              },
         *          }]
         *
         *  }
         *
         * Supported functions:
         * none external.  In order to programmatically change tabs, change the hash in the browser.
         *
         */
        return declare("app/widgets/SubLevelTabManager", [TabManager], {

            subConfiguration : null,

            /**
             *
             */
            postCreate : function() {
                var _this = this;
                this.inherited(arguments);

                if (!this.tabNode) {
                    this.tabNode = this.defaultTabNode;
                }
                else {
                    domClass.add(this.defaultTabNode, "hidden");
                }

                domClass.add(this.domNode, "tab-manager");

                // setup onclick for tabs
                array.forEach(this.subConfiguration, function (tab) {
                    var tabNode = domConstruct.create('a',{'class':tab.hash + " inlineBlock tab","href":"#",'innerHTML':'<span>' + tab.label + '</span>'}, _this.tabNode);
                    _this.tabs.push(tabNode);
                    tab.tabNode = tabNode;
                    on(tabNode, "click", function (e) {
                        e.preventDefault();
                        var tab = _this.getTab(e.target.innerText);
                        if (tab) {
                            _this.showTab(tab);
                        }
                    });

                });

                // Open tab on page load
                var tab = this.getTab();
                if(tab) {
                    _this.showTab(tab);
                }
                array.forEach(this.subConfiguration, function (tab) {
                    _this._loadTab(tab);
                });
            },

            /**
             * returns: a tab from the configuration list or null if none match.
             */
            getTab : function (name) {
                var t = null;
                // On page load, default to first tab in subConfiguration
                if (!name) {
                    t = this.subConfiguration[0];
                }
                array.every(this.subConfiguration, function (tab) {
                    if(tab.label === name) {
                        t = tab;
                        return false;
                    }
                    return true;
                });
                return t;
            },
            showTab : function(tab) {
                //notify the world that the tabs are changing
                topic.publish('TabManager/showTab');
                //Toggle selected tab css
                array.forEach(this.tabs, function (t) {
                    domClass.remove(t,"subSelected");
                });

                domClass.add(tab.tabNode, "subSelected");

                // Build tab if it doesn't already exist
                this._loadTab(tab);

                array.forEach(this.contentNode.children,function(child){
                    domClass.add(child, "hidden");
                });
                domClass.remove(this.cachedTabContent[tab.hash],"hidden");


            }

        }
    );
});
