/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define */
define(["dojo/_base/declare",
        "app/widgets/TextIcon"],
function(declare, TextIcon) {
    return declare("app/widgets/StatusTextIcon", [TextIcon],{
        label:"Not Started",
        type:"NOTSTARTED",
        postCreate: function() {
            this.type = this.type.toUpperCase();
            switch(this.type) {
                case 'OPEN':
                case 'WAITING':
                    this.label = i18n("Waiting");
                    break;
                case 'INPROGRESS':
                case 'EXECUTING':
                    this.label = i18n("In Progress");
                    break;
                case 'SKIPPED':
                    this.label = i18n("Skipped");
                    break;
                case 'NOTAPPLICABLE':
                    this.label = i18n("Not Applicable");
                    break;
                case 'COMPLETE':
                    this.label = i18n("Complete");
                    break;
                case 'NOTSTARTED':
                case 'PLANNED':
                    this.label = i18n("Planned");
                    break;
                default: // 'FAILED' 'FAILURE'
                    this.label = i18n("Failed");
                    break;
            }
            this.inherited(arguments);
        }
    });
});
