
define(["dojo/_base/declare",
        "dojo/dom-construct",
        "dojo/dom-class",
        "dojo/dom-style",
        "dojo/mouse",
        "dojo/on",
        "app/widgets/UReleaseWidget"],
function(declare,
        domConstruct,
        domClass,
        style,
        mouse,
        on,
        _URWidget
) {
    /** This widget provides a tab that shows on the side of the page that is by default collapsed.
     * When you click on it it will reveal its content body
     *
     * Parameters:
     * title: Title that will show at the top of the panel once expanded
     * content: Content body of the expanded panel. It is more likely some dom that will be defined ouside of the scope
     * of that widget
     * iconClass: class that will define what icon will be used on top of the panel when it is expanded and collapsed
     **/
    return declare("app/widgets/SideTabWidget",[_URWidget],{
        templateString:
            '<div class="side-tab-container-collapsed" data-dojo-attach-point="sideTabContainer">' +
            '<div class="side-tab-icon-container hidden" data-dojo-attach-point="sideTabIconContainer">' +
                '<div data-dojo-attach-point="sideTabMainIconTop">' +
                '</div>' +
            '</div>' +
            '<div class="side-tab-content-title hidden" data-dojo-attach-point="sideTabContentTitle">' +
            '</div>' +
            '<div class="side-tab-content hidden" data-dojo-attach-point="sideTabContent">' +
            '</div>' +
            '<div class="side-tab-toggle hidden" data-dojo-attach-point="sideTabToggle">' +
            '</div>' +
            '<div class="side-tab-side-icon" data-dojo-attach-point="sideTabSideIcon">' +
                '<div data-dojo-attach-point="sideTabMainIconRight">' +
                '</div>' +
            '</div>' +
            '</div>',

        title: null,
        content: null,
        iconClass: null,
        toggle: null,

        postCreate: function () {
            var _this = this;

            _this.setToggleValue(_this.toggle);

            //Displays the content provided
            _this.showFilterForm = function () {
                var _this = this;
                domConstruct.place(_this.content,_this.sideTabContent);
            };

            //Open the tab
            _this.expand = function () {
                var _this = this;
                domClass.replace(_this.sideTabContainer, "side-tab-container", "side-tab-container-collapsed");
                domClass.toggle(_this.sideTabContent, "hidden");
                domClass.toggle(_this.sideTabIconContainer, "hidden");
                domClass.toggle(_this.sideTabContentTitle, "hidden");
                domClass.toggle(_this.sideTabToggle, "hidden");
                domClass.toggle(_this.sideTabSideIcon, "hidden");

                //We want to disconnect the click event listener on the entire tab when it is
                //expanded
                dojo.disconnect(_this.expandClickListener);
            };

            //Close the tab
            _this.collapse = function () {
                var _this = this;
                domClass.replace(_this.sideTabContainer, "side-tab-container-collapsed", "side-tab-container");
                domClass.toggle(_this.sideTabContent, "hidden");
                domClass.toggle(_this.sideTabIconContainer, "hidden");
                domClass.toggle(_this.sideTabContentTitle, "hidden");
                domClass.toggle(_this.sideTabToggle, "hidden");
                domClass.toggle(_this.sideTabSideIcon, "hidden");

                //Here it is tricky. We want to reconnect the click event listener on the entire tab when it is
                //collapsed. But because we just changed the state of the tab we don't want to activate the listener
                //right away or it will trigger the expand event we click collapse the tab and will keep it opened
                _this.collapsed = false;

                var doesContainContainerCollapsedTag = domClass.contains(_this.sideTabContainer, "side-tab-container-collapsed");
                _this.expandClickListener = dojo.connect(_this.sideTabContainer, "click", function(evt){
                    if (_this.collapsed && doesContainContainerCollapsedTag) {
                        _this.expand();
                    }
                    _this.collapsed = true;
                });
            };

            //We set the title
            if (!!_this.title) {
                this.sideTabContentTitle.innerHTML = _this.title;
            }

            //We set the content if provided
            if (!!_this.content) {
                _this.showFilterForm();
            }
            //We set the class for the main icon
            if (!!_this.iconClass) {
                //Add the header icon class if one is provided
                domClass.add(_this.sideTabMainIconTop, _this.iconClass);
                domClass.add(_this.sideTabMainIconRight, _this.iconClass);
            }

            //By default the tab is collapsed and when you click on it it will expand
            _this.expandClickListener = dojo.connect(_this.sideTabContainer, "click", function(evt){
                if (domClass.contains(_this.sideTabContainer, "side-tab-container-collapsed")) {
                    _this.expand();
                }
            });

            //If the user clicks on the side toggle when the tab is expanded it will close it
            on(_this.sideTabToggle, "click", function(evt){
                _this.collapse();
            });
        },

        setToggleValue: function (toggle) {
            this.toggle = toggle;
            if (!!toggle) {
                domClass.add(this.sideTabContainer, "side-tab-container-toggled");
            }
            else {
                domClass.remove(this.sideTabContainer, "side-tab-container-toggled");
            }
        }
    });
});
