/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, noop*/
define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/_base/array",
    "app/widgets/UReleaseWidget",
    "js/webext/widgets/ColumnForm"],
function(
    declare,
    lang,
    array,
    _URWidget,
    ColumnForm
) {
    return declare([_URWidget, ColumnForm],{
        resource: null,
        onSubmit: function (data) {
            var _this = this;
            array.forEach(this.fieldsArray, function (field) {
                _this.resource.set(field.name, field.get('value'));
            });
            this.resource.save().then(lang.hitch(this,this._postSubmit));
        },
        postSubmit: function () {
            //no-op never op.  This is not built to handle async in ColumnForm
        },
        _postSubmit: function (data) {
            //no-op by default
        }
    });
});
