/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
 define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "app/widgets/ResourceList"
], function (
    declare,
    array,
    ResourceList
) {

    /**
     * @extends ResourceList
     */
    return declare([ResourceList], {
        getDisplayList: function() {
            var _this = this;
            var result = [];
            if(!this.model.isLoaded) {
                this.model.load().then(function () {
                    return _this.getDisplayList();
                });
            } else {
                array.forEach(this.model.getMembers(), function(member) {
                    if (_this.filterMember(member)) {
                        result.push(member);
                    }
                });

                //return result;
            }
        }
    });
});
