/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define("app/widgets/FieldValidation", [], function(){


    var cls = {
            maxLength : function maxLength(length){
                var lengthCheck = function lengthCheck(submittedValues, validation) {
                    var result = null;
                    var submitted = submittedValues[validation.name];

                    if (submitted && submitted.length > length) {
                        var displayName = validation.label || validation.name;
                        result = i18n("%s length must be less than %s characters.", displayName, length);
                    }
                    return result;
                };
                return lengthCheck;
            },

            minimum : function minimum(min) {
                var durationCheck = function minCheck(submittedValues, validation) {
                    var result = null;
                    var submitted = submittedValues[validation.name];
                    if (submitted && submitted.length < min) {
                        var displayName = validation.label || validation.name;
                        result = i18n("%s must be at least %s characters.", displayName, min);
                    }
                    return result;
                };
                return durationCheck;
            },

            match : function match(other) {
                var matchCheck = function matchCheck(submittedValues, validation) {
                    var result = null;
                    if (submittedValues[validation.name] !== submittedValues[other]) {
                        var displayName = validation.label || validation.name;
                        result = i18n("%s must match.", displayName);
                    }
                    return result;
                };
                return matchCheck;
            },

            required : function required() {
                var requiredCheck = function requiredCheck(submittedValues, validation) {
                    var result = null;
                    if (!submittedValues[validation.name] || submittedValues[validation.name] === "") {
                        if (submittedValues[validation.name] !== 0) {
                            var displayName = validation.label || validation.name;
                            result = i18n("%s is required.", displayName);
                        }
                    }
                    return result;
                };
                return requiredCheck;
            },

            integer : function isInteger() {
                var numericCheck = function numericCheck(submittedValues, validation) {
                    var result = null;
                    if (submittedValues[validation.name].search(/^-?\d+$/g) === -1) {
                        var displayName = validation.label || validation.name;
                        result = i18n("%s is not a positive number.", displayName);
                    }
                    return result;
                };
                return numericCheck;
            },

            unsignedInt : function isUnsignedInteger() {
                var numericCheck = function numericCheck(submittedValues, validation) {
                    var result = null;
                    if (submittedValues[validation.name].search(/^\d+$/g) === -1) {
                        var displayName = validation.label || validation.name;
                        result = i18n("%s is not a positive number.", displayName);
                    }
                    return result;
                };
                return numericCheck;
            },

            /**
             * currently just used for comparing start date and end date on EventRow.js
             * returns true iff the given number is less than 'other' AND the given number is greater than zero
             * users pass in a failure message to allow this function to be more flexible.
             */
            greaterThanOrEqualOrNull : function greaterThanOrEqualOrNull(other, message) {
                var greaterThanCheck = function matchCheck(submittedValues, validation) {
                    var result = null;
                    //if the given field is positive
                    if (submittedValues[validation.name] > 0 &&
                            //if the given field is less than other
                            submittedValues[validation.name] < submittedValues[other]) {
                        var displayName = validation.label || validation.name;
                        //failed message is passed in.
                        result = message;
                    }
                    return result;
                };
                return greaterThanCheck;
            },

            valid : function isValid(field) {
                var result = function requiredCheck(submittedValues, validation) {
                    var result = null;
                    if (field.getAttribute("aria-invalid") === "true") {
                       var displayName = validation.label || validation.name;
                       result = i18n("%s is not valid.", displayName);
                    }
                    else {
                        result = null;
                    }
                    return result;
                };
                return result;
            }
    };

    return cls;
});
