/*global define */
define([
        "dojo/_base/declare",
        "dijit/form/TimeTextBox",
        "dijit/form/DateTextBox",
        "js/webext/widgets/DateTime",
        "app/widgets/calendar/DetailCalendarDropdown",
        "app/widgets/calendar/DetailDateTextBox"
        ],
function(
        declare,
        TimeTextBox,
        DateTextBox,
        DateTime,
        DetailCalendarDropdown,
        DetailDateTextBox
) {
    /**
     * A combined TimeTextBox & DateTextBox widget
     */
    return declare("app/widgets/EventDateTime", [DateTime],
        {
            /**
             * whether or not the widget is disabled
             */
            disabled:false,

            showWidget: function() {
                var _this = this;

                // CUSTOM EVENT DATE CALENDAR
                if(_this.value) {
                    this.date = new DetailDateTextBox({
                        // this allows for the date part of this widget to become disabled
                        disabled: this.disabled,
                        value: new Date(this.value)
                    }, this.dateAttach);
                } else {
                    this.date = new DetailDateTextBox({
                        // this allows for the date part of this widget to become disabled
                        disabled: this.disabled
                    }, this.dateAttach);
                }

                // Same as DateTime.js
                this.date.domNode.style.width = "110px";
                this.date.domNode.className += " date-box-picker";
                this.time = new TimeTextBox({
                    value: new Date(this.value),
                    // XXX removing disable: this.disabled allows the text of the dropdown to be edited.
                    disabled: this.disabled,
                    onChange: function() {
                        _this.onChange(_this.get("value"));
                    }
                }, this.timeAttach);
                this.time.domNode.className += " time-box-picker";
            },

            onChange: function() {
                // no-op by default
            }
        }
    );
});
