//GLOBALIZED
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define */
define(["dojo/_base/declare",
        "dojo/dom-construct",
        "dojo/dom-class",
        "dojo/dom-style",
        "dojo/mouse",
        "dojo/on",
        "app/widgets/UReleaseWidget"],
function(declare,
        domConstruct,
        domClass,
        style,
        mouse,
        on,
        _URWidget) {
    return declare("app/widgets/EllipsisWidget",[_URWidget],{
        templateString:
            '<div style="position:relative" data-dojo-attach-point="ellipsisContainerAP">' +
                '<span class="ellipsis ellipsis-on" data-dojo-attach-point="ellipsisContentAP">' +
                '</span>' +
                '<div class="ellipsis-button hidden" data-dojo-attach-point="ellipsisButtonAP">' +
                '</span>' +
            '</div>',

        content: null,

        postCreate: function() {
            var _this = this;

            if(!!_this.content) {
                this.ellipsisContentAP.innerHTML = _this.content;
            }

            this.ellipsisButtonAP.innerHTML = "+";

            domClass.remove(_this.ellipsisButtonAP, "hidden");

            on(_this.ellipsisContainerAP, "click", function(evt){
                domClass.toggle(_this.ellipsisContentAP, "ellipsis-on");

                if(_this.ellipsisButtonAP.innerHTML === "+") {
                    _this.ellipsisButtonAP.innerHTML = "-";
                } else {
                    _this.ellipsisButtonAP.innerHTML = "+";
                }
            });

            on(_this.ellipsisContainerAP, mouse.enter, function(){
                domClass.add(_this.ellipsisButtonAP, "ellipsis-hover");
              });

            on(_this.ellipsisContainerAP, mouse.leave, function(){
                domClass.remove(_this.ellipsisButtonAP, "ellipsis-hover");
              });

        },

        /*******************************************************************************************
         * Removes Ellipsis when not needed
         ******************************************************************************************/
        startup: function() {
            var _this = this;

            if(_this.ellipsisContainerAP.scrollWidth >= _this.ellipsisContentAP.scrollWidth) {
                domClass.add(_this.ellipsisButtonAP, "hidden");
            } else {
                domClass.remove(_this.ellipsisButtonAP, "hidden");
            }
        }
    });
});
