/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define(["dojo/_base/declare",
        "dojo/_base/array",
        "dojo/_base/lang",
        "dojo/on",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-attr",
        "dijit/form/Select",
        "dijit/form/Button",
        "dijit/form/TextBox",
        "app/model/ResourceRegistry",
        "js/webext/widgets/GenericConfirm",
        "js/webext/widgets/ContentContainer"],
        function (declare, array, lang, on, domClass, domConstruct, domAttr, Select, Button, TextBox, Registry, Confirm, ContentContainer) {

        /**
         * A simple widget to show the standard content container dom structure around some block of
         * page content. Must mirror the contentContainer JSP tag.
         */


        /**
         * Arguments:
         * {
         *     title: String | Widget | domNode
         *     subtitle: String | Widget | domNode
         *     model: Resource
         *
         * }
         *
         * Notes:  the attachpoint "externalAttach" is intended to be used as a hook for other widgets to add content to the header probably in inlineBlock form
         *
         */
        return declare("app/widgets/DynamicContentContainer",
                [ContentContainer], {



            templateString:
                '<div class="content-container">' +
                    '<div class="container-header-box">' +
                        '<div class="header-container inlineBlock" data-dojo-attach-point="headerContainerAttach">' +
                            '<div data-dojo-attach-point="headerAttach" class="container-header"></div>' +
                            '<div data-dojo-attach-point="subheaderAttach" class="container-subheader"></div>' +
                        '</div>' +
                        '<div class="external-container inlineBlock">' +
                            '<div data-dojo-attach-point="externalAttach" class="external-space inline-block"></div>' +
                            '<div data-dojo-attach-point="externalButtonAttach" class="external-button-space inline-block"></div>' +
                        '</div>' +
                    '</div>' +
                    '<div data-dojo-attach-point="containerAttach" class="container-content"></div>' +
                    '<div class="container-footer"></div>' +
                '</div>',
            model: null,
            currentSelection: null,
            widgetClass: null,
            contentId: null,
            /**
             *
             */
            postCreate: function() {
                this.inherited(arguments);
//                this._displaySelectionContents();
            },

            show: function (model) {
                // show(null) is essentially a request to clear the container
                if (!model) {
                    this._destroySelectionContents();
                    this._destroyHeaderContents();
                }
                else {
                    this.model = model;
                    this._refreshHeaderContents();
                    this._refreshSelectionContents();
                    if (!!this.contentId) {
                        domAttr.set(this.domNode, "data-content-id", this.contentId);
                    }
                }
            },
            /*****************************************************
             * "PRIVATE" METHODS
             *****************************************************/

            /**
             * Add a new Resource to the current list of models selected
             */
            _addNewResourceAndRefreshSelection : function () {
                var promise,
                    _this = this;
                    if(!this.modelClass) {
                        this.modelClass = lang.getObject(this.model.declaredClass);
                    }
                    var resource = new this.modelClass({name:this.newResourceInput.get('value')});

                promise = resource.save().then(function () {
                    _this.model.addMember(resource);
                });
                return promise;
            },
            /**
             * Destroy (if exists) and then display the contents of a model
             */
            _refreshSelectionContents : function (initialSelectionId) {
                this._destroyHeaderContents();
                this._displayHeaderContents(initialSelectionId);
                this._destroySelectionContents();
                this._displaySelectionContents(initialSelectionId);
            },
            /**
             * Display the contents of the model selected in the dropdown
             */
            _displaySelectionContents : function (selectionId) {
                var _this = this;
                var WidgetClass = this.widgetClass;

                    _this.content = new WidgetClass({
                        model:this.model
                    }).placeAt(_this.containerAttach);
            },
            /**
             * Destroy the contents of the model selected in the dropdown
             */
            _destroySelectionContents : function () {
                if(this.content && this.content.destroyRecursive) {
                    this.content.destroyRecursive();
                }
            },
            _refreshHeaderContents: function (initialSelectionId) {
                this._destroyHeaderContents();
                this._displayHeaderContents();
            },
            _displayHeaderContents: function (initialSelectionId) {
                this.headerAttach.innerHTML = this.model.getHTML('name');
            },
            _destroyHeaderContents: function () {
                    domConstruct.empty(this.headerAttach);
            }
        });
});

