/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/fx",
    "dojo/_base/lang",
    "dojo/dom-class",
    "dojo/dom-style",
    "app/widgets/ResourceTable",
    "app/widgets/Dnd/_ResourceDndMixin"
], function (
    declare,
    array,
    coreFx,
    lang,
    domClass,
    domStyle,
    ResourceTable,
    _ResourceDndMixin
) {
    /**
     * Table variant of ResourceList which shows the members as rows in a table
     * Takes an object following:
     *  {
     *      model: Resource instance containing a collection
     *      widgetClass: The dojo "class" object to instantiate for each member of the collection
     *      canCopy: Determines if item can be copied during drag and drop (Hold ctrl key). Default false.
     *      checkedSelect: If the table uses a check box select style, set true to use check box state to determine row selection.
     *      dropIntoItem: Disables drag and drop function and item from a different dnd list and drag items into an item in the list to apply values.
     *      applyOnDropExternal: Determines if item applies a value when dropping to another dnd list. Set true if item will be dropping into a dropIntoItem list.
     *      externalDropOnly: Only allows items to be dragged into another dnd list. Cannot reorder items. Should be paired with a dropIntoItem list.
     *  }
     */
    return declare("app/widgets/DndResourceTable",
            [ResourceTable, _ResourceDndMixin], {

        domIdsToWidgets : null,
        skipRedraw: false,

        postCreate: function() {
            this._initializeDnd(); // @see _ResourceDndMixin
            this.inherited(arguments);
        },

        /**
         * Show a new row for adding a new object
         * The anchor is the child we are using as the anchor to insert
         * before (boolean) before (value of 1) or after (value of 0)
         */
        showBlankChild: function(anchor, before) {
            // Only show the row if we don't have one, if the one we had is saved (has an ID), or if the one
            // we had is deleted (no domNode)
            if (!this.blankModel || this.blankModel.resourceId || !this.blankChild.domNode) {
                var modelClass = this.model.declaredClass;
                var ModelClassObject = lang.getObject(modelClass);
                this.blankModel = new ModelClassObject({}, this.model);
                var index;
                if (!! anchor && (before !== undefined)) {
                    index = array.indexOf(anchor.parentNode.childNodes, anchor);
                    if (before) {
                        index--;
                    }
                }
                this.blankChild = new this.widgetClass({
                    "containingList": this,
                    "model": this.blankModel,
                    "listModel": this.model,
                    "className": "new-item resource",
                    "index": index
                });
                domStyle.set(this.blankChild.domNode, "display", "none");
                if (!!anchor && (before !== undefined)) {
                    this.dnd.insertNodes(false, [this.blankChild.domNode], before, anchor);
                }
                // Determines if a new item is to be displayed at the top of the list.
                else if (this.newItemAtTop || this.newItemPlacement === "first"){
                    this.dnd.insertNodes(false, [this.blankChild.domNode], this.domNode);
                    domClass.remove(this.blankChild.domNode,"new-item");
                    domClass.add(this.blankChild.domNode,"new-item-top");
                }
                else {
                    this.dnd.insertNodes(false, [this.blankChild.domNode]);
                }
                this.domIdsToWidgets[this.blankChild.domNode.id] = this.blankChild;

                coreFx.wipeIn({
                    node: this.blankChild.domNode,
                    duration: this.animationSpeed
                }).play();
            }
            this._setEvenOddClasses();
        },

        refresh: function() {
            //domConstruct.empty(this.listAttach);
            this.model.load();
            //this.show();
        }
    });
});
