/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/fx",
    "dojo/dom-class",
    "dojo/dom-construct",
    "app/widgets/ResourceList",
    "app/widgets/Dnd/_ResourceDndMixin"
], function (
    declare,
    coreFx,
    domClass,
    domConstruct,
    ResourceList,
    _ResourceDndMixin
) {

    return declare("app/widgets/DndResourceList",
            [ResourceList, _ResourceDndMixin], {

        animationSpeed: 80,

        /**
         * @private
         */
        postCreate: function() {
            this._initializeDnd(); // @see _ResourceDndMixin
            this._initializeTable(); // @see ResourceList
            this.inherited(arguments);
        },

        /**
         * Show a new row for adding a new object, overridden to use the dnd widget
         * needed to perform dnd.
         *
         * @override ResourceList:showBlankChild()
         * @private
         * @see ResourceList::showBlankChild()
         */
        showBlankChild: function(anchor, before) {
            this._createBlankChild();
            // Only show the row if we don't have one, if the one we had is saved (has an ID), or if the one
            // we had is deleted (no domNode)
            // Determines if a new item is to be displayed at the top of the list.
                if (this.newItemPlacement === "first") {
                    domClass.remove(this.blankChild.domNode,"new-item");
                    domClass.add(this.blankChild.domNode,"new-item-top");
                    this.dnd.insertNodes(false, [this.blankChild.domNode], this.domNode);
                }
                else {
                    this.dnd.insertNodes(false, [this.blankChild.domNode]);
                }
                this.domIdsToWidgets[this.blankChild.domNode.id] = this.blankChild;
                domClass.remove(this.blankChild.domNode,"dojoDndItem");
                coreFx.wipeIn({
                    node: this.blankChild.domNode,
                    duration: this.animationSpeed
                }).play();
            this._setEvenOddClasses(); // @see _resourceDndMixin
        },

        /**
         * @see ResourceList
         */
        refresh: function() {
            var _this = this;
            domConstruct.empty(this.listAttach);
            this.model.load().then(function () {
                _this.show();
            });
        }
    });
});
