/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/_base/lang",
    "dojo/on",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/Dialog",
    "dijit/form/Button",
    "js/webext/widgets/ColumnForm",
    "js/webext/widgets/RestSelect",
    "app/widgets/ResourceTable"
], function (
    declare,
    array,
    lang,
    on,
    domConstruct,
    domStyle,
    Widget,
    TemplatedMixin,
    Dialog,
    Button,
    ColumnForm,
    RestSelect,
    ResourceTable
) {

    /**
     * Detail View pane of a TreeDetailView
     * arguments:
     * }
     */
    return declare([Widget, TemplatedMixin], {
        tableDataSources:[], //Extended in subclass
        // [{
        //  name: "", Title for the table
        //  url: "", url appended to /basePath/TreeTableModelPath/
        //  resource: "" declaredClass
        //  row: "" extension of ResourceRow that corresponds to the resource loaded
        // },{
        //   Another object like above
        // }]
        resourceId: null, // Id of the TreeDetailView TreeTable item for which this is a detail view.  Used to make REST requests to gather more data

        templateString :
            '<div class="detail-view-container" data-dojo-attach-point="detailViewAP">' +
                '<div class="detail-view-header" data-dojo-attach-point="detailViewHeader"></div>' +
                '<div data-dojo-attach-point="detailViewContentAP"></div>' +
            '</div>',
        /**
         * hide this widget from view
         */
        hide : function () {
            domStyle.set(this.detailViewAP,{"display":"none"});
        },

        show : function () {
            domStyle.set(this.detailViewAP,{"display":"block"});
        },
        /****************************************************************
         * Private Methods
         ***************************************************************/
        postCreate : function () {
            this._generateHeaderName();
            this._requestAssociationsFromServer();
            //this._generateTables();
        },
        /**
         * Create the title text for the DetailView
         */
        _generateHeaderName : function () {
            domConstruct.create('h1',{
                innerHTML:this.model.get('name'),
                className: "container-header"
            }, this.detailViewHeader);
        },

        /**
         * Make the GET requests from each of the REST endpoints defined by the extension of DetailView (see OrganizationDetailView as an example)
         */
        _requestAssociationsFromServer : function () {
            var _this = this;
            this.tableDataSources.sort(function (a,b) {
                return a.name.toUpperCase() > b.name.toUpperCase();
            });
            array.forEach(this.tableDataSources, function (source) {
                var ResourceClass = source.resource;
                var resource = new ResourceClass([],null,_this.model.get('id'));
                var tableContainer = domConstruct.create("div",{
                    className: "detail-view-section"
                }, _this.detailViewContentAP);
                resource.load().then(function () {
                    var table = new ResourceTable({
                        model:resource,
                        addLabel:null,
                        widgetClass:source.row
                    }).placeAt(tableContainer);
                    domConstruct.create('h2',{
                        className: "inline-block",
                        innerHTML:source.name
                    }, table.titleAttach);
                    var addButton = domConstruct.create("a", {
                        className: "text-button detail-view-add-button",
                        innerHTML: "<div class=\"resource-button inline-block add-button\"></div>Add " + source.name
                    }, table.titleAttach);
                    this.own(on(addButton, "click", function () {
                        _this._generateAddDialog(table,source);
                    }));
                });

            });
        },

        /**
         * create and show a Dialog associated with the add button's click event
         */
        _generateAddDialog : function (table,source) {
            var _this = this;
            this.dialog = new Dialog();
            //this.dialog.placeAt(this.detailViewAP);


            var newUrl = this.model.getResourcePath();
            var form = new ColumnForm({
              submitUrl: newUrl,
              submitMethod: "POST",
              submitFormat: "JSON",
              postSubmit: function(data, ioArgs) {
                  _this.dialog.hide();
                  //_this.dialog.destroy();
                  table.model.load();//show();
              },
              onCancel: function() {
                  _this.dialog.hide();
                  _this.dialog.destroy();
              }
            });

            var urlPrefix;
            if(source.url === 'release') { //release is different.  It's on the org controller since there can only be one on any given org
                urlPrefix = this.model.getResourcePath();
            } else {
                urlPrefix = uReleaseConfig.urls.base;
            }


            var select = new RestSelect({
                restUrl : urlPrefix + source.url,
                getLabel : function(item) {
                    return item.name;
                },
                getValue : function(item) {
                    return item.id;
                },
                //isValid : function(item) {
                    //return !!item.id && item.id === this.model.get("id");
                //},
                noneLabel : i18n("--- Select ---"),
                onChange : function (value) {
                    form.submitUrl = _this.model.getResourcePath() + _this.model.get('id') + "/" + source.url + "/" + value;
                }
            });

            form.addField({
              label:i18n("Select %s", source.name),
              name: "",
              widget: select
            });


            form.placeAt(this.dialog.containerNode);
            this.dialog.show();
        }

    });
});
