/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014, 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define */
define([
        "dojo/_base/declare",
        "js/webext/widgets/Dialog",
        "dojo/dom-construct",
        "app/widgets/CustomCalendarWidget",
        "dojo/on",
        "dojo/dom-class",
        "dijit/form/Button"
        ],
function(
        declare,
        Dialog,
        domConstruct,
        CustomCalendarWidget,
        on,
        domClass,
        Button
) {
            return declare(
                "app/widgets/DateRangePickerDialog",
                [Dialog],
                {
                    startDateRangePicker:null,
                    endDateRangePicker: null,
                    filterWidget: null,
                    filterForm: null,
                    startValue: null,
                    endValue: null,
                    triggerFilter: function() {
                        var _this = this;
                        _this.filterForm.submit();
                    },
                    clearFilter: function() {
                        var _this = this;
                        _this.startDateRangePicker.value="";
                        _this.endDateRangePicker.value="";
                        _this.startValue = _this.startDateRangePicker.value;
                        _this.endValue =_this.endDateRangePicker.value;
                        _this.filterWidget.onChange();
                        _this.triggerFilter();
                    },
                    postCreate: function() {
                        this.inherited(arguments);
                        var _this = this;
                        _this.startValue = _this.startDateRangePicker.value;
                        _this.endValue =_this.endDateRangePicker.value;
                        var TitleNode = domConstruct.create("span",{
                            "class":"date-range-filter-title",
                            "innerHTML": i18n("Select Range For Date Filter")
                        },_this.titleNode);

                        var dateRangeContentContainer = domConstruct.create("div", {
                            "class":"date-range-filter-content-container"
                        },_this.containerNode);

                        var initFromValue = (!!_this.startDateRangePicker.value)?(new Date(Number(_this.startDateRangePicker.value))).toISOString():null;
                        var initToValue = (!!_this.endDateRangePicker.value)?(new Date(Number(_this.endDateRangePicker.value))).toISOString():null;
                        var fromCalendar = new CustomCalendarWidget({
                            value: initFromValue
                        });
                        var toCalendar = new CustomCalendarWidget({
                            value: initToValue
                        });
                        var fromCalendarContainer = domConstruct.create("div",{
                            "class":"date-filter-from-calendar-container date-range-filter-calendar-container"
                        }, dateRangeContentContainer);

                        var calendarSeparator= domConstruct.create("div",{
                            "class":"date-range-calendar-separator",
                            "innerHTML":"&mdash;"
                        }, dateRangeContentContainer);

                        var toCalendarContainer = domConstruct.create("div",{
                            "class":"date-filter-to-calendar-container date-range-filter-calendar-container"
                        }, dateRangeContentContainer);

                        on(fromCalendar,"valueSelected",function(data){
                            _this.startValue = data.getTime();
                        });

                        on(toCalendar,"valueSelected",function(data){
                            _this.endValue = data.getTime();
                        });

                        fromCalendarContainer.appendChild(fromCalendar.domNode);
                        var fromTextContainer  = domConstruct.create("div",{
                            "class":"date-range-from-text-container calendar-type-text-container"
                        }, fromCalendarContainer);

                        var fromText  = domConstruct.create("span",{
                            "class":"date-range-from-text calendar-type-text",
                            "innerHTML":i18n("From")
                        }, fromTextContainer);

                        toCalendarContainer.appendChild(toCalendar.domNode);
                        var toTextContainer  = domConstruct.create("div",{
                            "class":"date-range-to-text-container calendar-type-text-container"
                        }, toCalendarContainer);

                        var toText  = domConstruct.create("span",{
                            "class":"date-range-to-text calendar-type-text",
                            "innerHTML":i18n("To")
                        }, toTextContainer);

                        domClass.add(fromCalendar.domNode,"from-node-filter");
                        var buttonContainer = domConstruct.create("div", {
                            "class":"date-range-filter-button-container"
                        },_this.containerNode);

                        var executeFilterButton =   new Button({
                            onClick: function() {
                                _this.startDateRangePicker.value = _this.startValue;
                                _this.endDateRangePicker.value = _this.endValue;
                                _this.filterWidget.onChange();
                                _this.triggerFilter();
                                _this.hide();
                            },
                            label: i18n("Filter")
                        }).placeAt(buttonContainer);

                        var clearFilterButton =   new Button({
                            onClick: function() {
                                _this.clearFilter();
                                _this.hide();
                            },
                            label: i18n("Clear")
                        }).placeAt(buttonContainer);

                        var cancelFilterButton =   new Button({
                            onClick:  function() {
                                _this.hide();
                            },
                            label: i18n("Cancel")
                        }).placeAt(buttonContainer);
                    }
                }
            );
    });