/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/fx",
    "app/widgets/UReleaseWidget"
], function (
    declare,
    array,
    domClass,
    domConstruct,
    on,
    coreFx,
    UReleaseWidget
) {
    return declare("app/widgets/CustomContextMenu", [UReleaseWidget], {
        templateString: "<div data-dojo-attach-point='menu'></div>",
        // Give user ability to use custom parent and child widgets
        isOpen: false,
        postCreate: function() {
            var _this = this;
            this.inherited(arguments);
            domClass.add(this.domNode, "custom-context-menu");
            _this.buildMenu();
        },

        buildMenu: function() {
          var _this = this;
          var root = _this.attachPoint;
          var children = _this.model.getMembers();
          var buttonContainer = _this.buttonContainer;
          var item;

          array.forEach(children, function(child, index) {
            var itemContainer = domConstruct.create("div", {
                "class": "context-menu-child"
            }, _this.menu);
            item = new _this.widgetClass({
                model: _this.model.getMembers()[index]
            });
            item.placeAt(itemContainer);
          });
          dojo.place(_this.menu, root);
          _this.isOpen = true;
        },

        _expandMenu: function() {
            domClass.remove(this.menu, "hidden");
            coreFx.wipeIn({
              node: this.menu
            }).play();
            this.isOpen = true;

        },

        _collapseMenu: function() {
            coreFx.wipeOut({
              node: this.menu
            }).play();
            this.isOpen = false;
        }

    });

});
