/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/_base/Color",
    "dojo/_base/array",
    "dijit/_WidgetBase"
], function(declare, Color, array, Widget) {
    return declare([Widget],{

        postCreate: function() {
            this.inherited(arguments);

        },

        destroy: function() {
            this.destroyRecursive();
            this.inherited(arguments);
        },

        /**
         * Determines is given color is dark.
         */
        isDarkColor : function(color) {
            var rgbColor = new Color(color).toRgb();
            //
            var colorWeight = 1 - (0.25 * rgbColor[0] + 0.6 * rgbColor[1] + 0.1 * rgbColor[2]) / 255;
            return colorWeight > 0.5;
        },

        /**
         * Returns a lighter tint of a given color.
         */
        getTint : function(color, delta) {
            delta = delta || 1.6;
            return this._alterColor(color, delta);
        },

        /**
         * Returns a darker shade of a given color.
         */
        getShade : function(color, delta) {
            delta = delta || 0.6;
            return this._alterColor(color, delta);
        },
        _alterColor : function (color, delta) {
            var rgbColor = new Color(color).toRgb(),
                tint = [];
            array.forEach(rgbColor, function(hue){
                tint.push(delta * hue);
            });
            return Color.fromArray(tint).toHex();
        }

    });
});
