/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
        "dojo/_base/declare",
        "dojo/_base/array",
        "app/widgets/UReleaseWidget",
        "app/widgets/CustomColorPicker/_Color"
],
function(declare, array, UReleaseWidget, Color) {
    return declare([UReleaseWidget],{
        colors:null,
        selectedColor:null,

        templateString:
            '<div>' +
                '<div class="selectedColor" data-dojo-attach-point="selectedColorAP"></div>' +
                '<div class="colors" data-dojo-attach-point="colorsAP"></div>' +
            '</div>',
        postCreate: function() {
            this.inherited(arguments);
            var _this = this;
            if(this.colors instanceof Array) {
                array.forEach(this.colors, function (color) {
                    _this.createColorBox(color);
                });
            }
        },

        createColor: function (color) {
            this.colorWidgets.push(new Color(color));
        },

        setSelectedColor : function () {

        },

        destroy: function() {
            this.destroyRecursive();
            this.inherited(arguments);
        }
    });
});
