//GLOBALIZED
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define */
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/dom-construct",
    "dojo/dom-class",
    "dojo/dom-style",
    "dojo/on",
    'dojo/aspect',
    "dijit/Calendar",
    "dojo/mouse",
    "app/widgets/Popup",
    "app/widgets/UReleaseWidget",
    "app/model/calendar/CalendarEvent",
    "app/model/ResourceRegistry",
    "app/widgets/CustomColorPicker/_Color"], //Used to determine whether or not dark color
function(
    declare,
    array,
    domConstruct,
    domClass,
    domStyle,
    on,
    aspect,
    Calendar,
    mouse,
    Popup,
    _URWidget,
    CalendarEvent,
    Registry,
    Color) {
    return declare("app/widgets/CustomCalendarWidget",[Calendar],{
        postCreate: function() {
            this.inherited(arguments);
            var _this = this;
            _this.connect(_this.monthWidget, '_setMonthAttr', function(value){
                _this.refreshColors();
                });
            this.refreshColors();

        },
        refreshColors: function(){
            var _this = this;

            // This is a new month, so clear out all the handlers that the last month had on each of
            // its days
            _this.clearDayHandlers();

            _this.eventsModel = new CalendarEvent();

            // we must account for up to two weeks before the start of the month and two weeks after
            // the end of the month because that is potentially what the calendar widget shows
            var twoWeeks = 604800000 * 2;
            var oneDay = 86400000;

            // Get the first day of this current month
            var monthStartDate = new Date(
                    _this.currentFocus.getUTCFullYear(), _this.currentFocus.getMonth(), 1);

            var monthEndDate;
            // Account for the next month being January
            if((_this.currentFocus.getMonth() + 1) % 12 === 0) {
                monthEndDate = new Date(_this.currentFocus.getUTCFullYear() + 1, 0, 1);
            }
            else {
                monthEndDate = new Date(_this.currentFocus.getUTCFullYear(), _this.currentFocus.getMonth() + 1, 1);
            }

            var monthStartTime = monthStartDate.getTime();
            // subtract 1 ms from the first ms of the next month
            var monthEndTime = monthEndDate.getTime() - 1;

            var color = new Color();

            // Query for the events that would show up on the calendar that month (and 2 weeks
            // and after the month)
            _this.eventsModel.query({"startDate":monthStartTime - twoWeeks, "endDate":monthEndTime + twoWeeks}).then(
                    function () {

                        var weekList = _this.dateRowsNode.childNodes;
                        var dateColorList = [];

                        // Instead of nesting the iterations of calendar boxes and events, we iterate through
                        // events and populate an array of colors so we can quickly iterate through the days

                        // This must be a two dimensional array so as to denote the month before the
                        // current focus ([0]), the current focused month ([1]), and the month after
                        // ([2]).

                        // Iterate through events
                        array.forEach(_this.eventsModel.members, function(event){
                            // Get start and end ms
                            var startDate = event.get("startDate");
                            var endDate = event.get("endDate");

                            //iterator
                            var i = startDate;

                            // for each event, update each day that the event spans
                            for(i; i<=endDate; i = i + oneDay) {
                                var date = new Date(i);

                                // If this day already has an event
                                if(!!dateColorList[date.toDateString()]) {
                                    // ...then make it "multiple"
                                    dateColorList[date.toDateString()] = ["multiple", i18n("Multiple Events")];
                                }
                                else {
                                    // ...or else set it as the color
                                    dateColorList[date.toDateString()] = [event.get("color"), event.get("name")];
                                }
                            }
                        });

                        // Iterate through the weeks on the calendar
                        array.forEach(weekList, function(week){
                            var days = week.children;

                            // Iterate through the days in the week
                            array.forEach(days, function(day){

                                // Get the date string for this day
                                var dateString = new Date(day.dijitDateValue).toDateString();

                                // Clear out the dark color class and background color
                                domClass.remove(day.firstChild, "dark-color");
                                domStyle.set(day.firstChild, "backgroundColor", "");

                                // If this day has multiple events give it the multiple event day
                                // class
                                if (!!dateColorList[dateString] && dateColorList[dateString][0] === "multiple") {
                                    domClass.add(day.firstChild, "multiple-event-day");
                                }
                                else {
                                    // Remove the multiple event day class
                                    domClass.remove(day.firstChild, "multiple-event-day");

                                    // If this day has a color assigned to it...
                                    if (!!dateColorList[dateString]) {
                                        // ... check if that color is a dark color
                                        if(color.isDarkColor(dateColorList[dateString][0])) {
                                            // ... Assign the dark color class if it is
                                            domClass.add(day.firstChild, "dark-color");
                                        }
                                        // ... and assign the color background
                                        day.firstChild.setAttribute("style","background-color: " + dateColorList[dateString][0] + " !important;");
                                    }
                                }


                                var dayPopup = null;

                                // If this date has an event and don't specify hidePopup
                                if(!!dateColorList[dateString] && !_this.hidePopup) {

                                    // Create a popup object
                                    var popupContent = domConstruct.create("div", {
                                        style: {
                                            "padding": "2px",
                                            "padding-right": "10px",
                                            "padding-bottom": "5px"
                                        }
                                    });

                                    // See if there are multiple events for that day
                                    if(dateColorList[dateString][0] !== "multiple") {
                                        // Create the appropriate colored box
                                        domConstruct.create("div", {
                                            className: "gate-color-container inline-block",
                                            style: {
                                                "backgroundColor": dateColorList[dateString][0]
                                            }
                                        }, popupContent);
                                    }

                                    // Put the name of event or "multiple events"
                                    popupContent.innerHTML += dateColorList[dateString][1];

                                    // Create the popup
                                    dayPopup = new Popup({
                                        attachPoint: day,
                                        contents: popupContent
                                    });
                                }

                                // Fire off the custom mouse over day event that is available for
                                // other widgets to pick up on
                                var dayHoverHandler = on(day, "mouseover", function() {
                                    _this.dayHoverEvent(day.dijitDateValue);
                                });

                                // When the month is changed, remove all listeners and popups from
                                // all the days (including this handler)
                                var handler = aspect.after(_this, 'clearDayHandlers', function() {
                                    dayHoverHandler.remove();
                                    if(!!dayPopup) {
                                        dayPopup.destroy();
                                    }
                                    handler.remove();
                                });
                            });

                        });
                    }

            );


        },
        dayHoverEvent : function(dateValue) {
            // Custom Mouse Over Event for a day being hovered over
            // No-Op by default
        },
        clearDayHandlers: function(arg) {
        }
    });
});
