/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define */
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/dom-class",
    "app/widgets/ResourceTable"
], function(
    declare,
    array,
    domClass,
    ResourceTable
) {

    return declare([ResourceTable],{
        //List of checked items
        checkedRows: null,

        postCreate: function() {
            this.checkedRows = {};
            this.inherited(arguments);
        },

        /**
         * @see app/widgets/ResourceTable
         */
        loadHeaders: function(){
            var _this = this;

            // TODO update this to use existing widget as template rather than instantiating a widget without a model
            // (I'm hacking a model in here to keep the Resource changes from breaking on this.)
            if (this.model.getMembers()[0]||(!!this.forceShowFilters)) {
                this.createFilterWidget();
            }
            if (this.showHeaders && this.filterWidgetPrototype && !this.headersLoaded) {
                this.filters = [];
                array.forEach(this.filterWidgetPrototype._getAlteredColumns(), function(column) {
                    _this.filterWidgetPrototype._buildColumnHeader(column);
                    _this._buildFilters(column);
                });
                this.headersLoaded = true;
            }
        },

        _createChildWidget: function(member) {
            var childWidget = this.inherited(arguments);

            var isChecked = this.checkedRows[member.resourceId];
            if (isChecked) {
                childWidget.checkbox.set('checked', true);
            }

            return childWidget;
        },

        selectAll: function(value) {
            var _this = this;
            array.forEach(this.childWidgets, function(childWidget) {
                // If ther row is hidden because it does not match a filter,
                // do not check it. XXX this is too direct.  We should not rely on the css
                // class to track state.
                if (!domClass.contains(childWidget.domNode, "does-not-match-filter") || _this.model.get('isPaginated')) {
                    childWidget.set('checked', value);
                }
            });
        },

        /**
         * @param property if a property is passed in, the method will return a list of model properties from each row, where the property name is equal to the argument
         *
         * example: this.getSelected('id') // could return ["5f697b57-54b1-4f33-a2f9-c0a0148f6d52", "cf6a258e-e64c-4418-ba36-860bc431df5d", "1defa3f4-485a-44e3-9ebf-62b4f1462bde"]
         */
        getSelected: function(property) {
            var result = [];
            array.forEach(this.childWidgets, function(childWidget) {
                if(childWidget.get('checked')) {
                    if(property) {
                        result.push(childWidget.model.get(property));
                    } else {
                        result.push(childWidget);
                    }
                }
            });
            return result;
        },

        /**
         * @param idArray, an array of ids, Resources, a single id as a string or a Resource that is a collection
         * @return a list of widgetRows that have been checked
         */
        setSelectedById: function(idArray) {
            //handle single id as string
            var result = [];
            if (typeof idArray === 'string') {
                idArray = [idArray];
            }
            if(typeof idArray === 'object' && idArray.declaredClass &&
                    idArray.isCollection) {
                idArray = idArray.getMembers();

            }
            //for all child widgets
            array.forEach(this.childWidgets, function(childWidget) {
                //for all ids until the first match
                array.some(idArray, function (id) {
                    //if it's actually a resource, get the id
                    if (typeof id === 'object') {
                        id = id.get('id');
                    }
                    if(childWidget.model && childWidget.model.get('id') === id) {
                        //if they match, set the row to checked
                        childWidget.set('checked', true);
                        result.push(childWidget);
                        return true;
                    }
                });
            });
            return result;
        }

    });
});
