/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
/*global define, i18n */
define([
    "dojo/_base/declare",
    "app/widgets/UReleaseWidget",
    "dojo/dom-attr",
    "dojo/dom-class",
    "dojo/dom-style",
    "dojo/on",
    "dojo/query"
], function(
    declare,
    _URWidget,
    domAttr,
    domClass,
    domStyle,
    on,
    query
) {
    /**
     * arguments:
     *
     * {
     *     @param {String} email The address to which email should be sent
     *                      (defaults to ucbeta@us.ibm.com)
     *     @param {String} subject The title of the feature, such that
     *                      "`title` is an experimental feature" would work as
     *                      a sentence. Also the subject of the email address in
     *                      plain text (it will be uri encoded)
     *     @param {String} message The alternative message to display instead of the default
     *     @param {String} address The alternative address to send the user to instead of a mailto link
     *     @param {String} iconClass An extra class to add to the icon if necessary, shows feedback icon by default
     */
    return declare([_URWidget],{
        templateString:
            '<div data-dojo-attach-point="betaNotice" class="beta-container">' +
                '<div data-dojo-attach-point="icon" class="beta-sprite"></div>' +
                '<span data-dojo-attach-point="content"></span>' +
            '</div>',
        email : "ucbeta@us.ibm.com",
        /**
         * this widget relies on UReleaseWidget calling initI18n to work.  Hence it has no postCreate.
         */
        _initI18n: function () {
            var _this = this;
            this.inherited(arguments);
            // default message
            if (!this.message) {
                this.content.innerHTML = i18n('<span>%s</span> is an <span class="beta-container-highlight">experimental</span> feature. Do you have any <span class="beta-container-highlight">feedback</span>? Please tell us what you think <a href="">here</a>.', this.subject);
            }

            // custom message supplied
            else {
                this.content.innerHTML = '<span>' + this.message + '</span>';
            }

            // generate an email link if address is not set
            this.address = this.address || this.generateEmailLink();

            // if there exists an <a> element in the content, set it's href to address
            var a = query("a", this.content);
            if (a.length > 0) {
                //XXX this is assuming that there is only one anchor tag within the dom node this.content.
                //A relatively safe assumption, but this should be done without query, once we can change the translated string.
                domAttr.set(a[0], "href", this.address);
            }

            // there was no <a> element in the content, make the entire box clickable
            else {
                this.own(on(this.betaNotice, "click", function() {
                    window.open(_this.address, "blank");
                }));
                domClass.add(this.betaNotice, "clickable");
            }


            this.iconClass = this.iconClass || "feedback";
            domClass.add(this.icon, this.iconClass);
        },

        generateEmailLink: function () {
            var i,l;
            var subject = this.subject;
            subject = subject.split(" ");
            for(i=0,l=subject.length;i < l;i++) {
                subject[i] = subject[i].capitalize();
            }
            subject = subject.join(" ");
            return "mailto:" + this.email + (subject ?
                    ("?subject=" + encodeURIComponent("Experiment: " + subject)) : "");

        },
        show: function () {
            domStyle.set(this.domNode, {"display":"block"});
        },
        hide: function () {
            domStyle.set(this.domNode, {"display":"none"});
        }
    });
});
