/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
        "dojo/_base/declare",
        "dojo/_base/array",
        "dijit/registry",
        "dojo/dom-construct",
        "dojo/dom-class",
        "dojo/query",
        "js/webext/widgets/Link",
        "app/widgets/UReleaseWidget",
        "app/widgets/DndResourceTable"
],
function (
          declare,
          array,
          registry,
          domConstruct,
          domClass,
          query,
          Link,
          UReleaseWidget,
          DndResourceTable
) {
    return declare("app/widgets/AssociationView/AssociationView",
            [UReleaseWidget], {
        associateToModel: null,             //the model that will back the dnd receiving (dropping) end
        associateFromModel: null,           //the model that will back the dnd sending (dragging) end

        associateToWidgetClass: null,       //the row widget that represents the table rows on the receiving (dropping) end
        associateFromWidgetClass: null,     //the row widget that represents the table rows on the sending (dragging) end
        onDropExternal:null, // Function : the method to call when making model associations on drop : the method to call when making model associations on drop

        addLabel:"",
        instructionText: "",

        templateString:
        "<div class=\"association-view\">"+
            "<div data-dojo-attach-point=\"viewAttach\"></div>"+
            "<div>" +
                "<div class=\"inline-block association-list\" data-dojo-attach-point=\"associationAttach\"></div>" +
                "<div class=\"inline-block associator-list\" data-dojo-attach-point=\"associatorAttach\"></div>" +
            "</div>"+
        "</div>",

        postCreate: function() {
            this.inherited(arguments);
            var applicationTarget = domConstruct.create("div", {
                "innerHTML": this.instructionText,
                "className": "association-help-text",
                "style": "height: 20px;"
            }, this.viewAttach);
            this.show();
        },

        /**
         *
         */
        show: function() {
            this.inherited(arguments);
            var _this = this;

            if (this.addLabelNode) {
                domConstruct.empty(this.addLabelNode);
            }
            var associationList = new DndResourceTable({
                model: this.associateToModel,
                widgetClass: this.associateToWidgetClass,
                addLabel: this.addLabel,
                dropIntoItem: true,
                newItemAtTop: true,
                className: "resource-list resource-table association-list inline-block",
                onDropExternal: this.onDropExternal
            });
            domConstruct.create("div", {
                "innerHTML": i18n("Release Environment"),
                "className": "association-title"
            }, associationList.titleAttach);
            domClass.add(associationList.listAttach, "scrollable-rows");
            associationList.placeAt(this.associationAttach);

            var associationExpander = domConstruct.create("div", {}, associationList.titleAttach);

            var associationExpandAll = new Link({
                "labelText":i18n("Expand All"),
                "className":"association-expand inlineBlock",
                "onClick":function () {
                    _this.toggleAssociationExpand(true);
                }
            });
            associationExpandAll.placeAt(associationExpander);
            domConstruct.create("span", {
                innerHTML: "|",
                "className": "association-expand-divider inlineBlock"
            }, associationExpander);

            var associationCollapseAll = new Link({
                "labelText":i18n("Collapse All"),
                "className":"association-expand inlineBlock",
                "onClick":function () {
                    _this.toggleAssociationExpand(false);

                }
            });
            associationCollapseAll.placeAt(associationExpander);

            domConstruct.create("span", {
                innerHTML: "|",
                "className": "association-expand-divider inlineBlock"
            }, associationExpander);

            var sortAscending = true;
            var sortAll = new Link({
                "labelText": "Sort: Descending",
                "className": "association-expand inlineBlock",
                "value": true,
                "onClick": function () {
                    var table = registry.byNode(query(".association-list")[0]);
                    var sortBy = {"sortBy": "name"};
                    if (sortAscending) {
                        table.applySort(sortBy, sortAscending);
                        this.set('labelText', i18n("Sort: Ascending"));
                        sortAscending = false;
                    }
                    else {
                        table.applySort(sortBy, sortAscending);
                        this.set('labelText', i18n("Sort: Descending"));
                        sortAscending = true;
                    }
                }
            }, associationExpander);
            sortAll.placeAt(associationExpander);

            var applicationList = new DndResourceTable({
                model: this.associateFromModel,
                widgetClass: this.associateFromWidgetClass,
                applyOnDropExternal: true,
                className: "resource-list resource-table associator-list inline-block",
                addLabel: false,
                externalDropOnly: true,
                customSort: function(column, sortStatus) {
                    var _this = this;
                    var sortColumn = column.sortBy;
                    var sortObject = column.sortByObject;
                    var sortCollection = column.sortByCollection;
                    this.childWidgets.sort(function(object1, object2){
                        var result = 0;
                        if (object1 !== undefined && object2 !== undefined){
                            var name = column.name;
                            var sortColumn1 = object1.model.get(sortColumn);
                            var sortColumn2 = object2.model.get(sortColumn);

                            if (name === "Application Name"){
                                if (sortColumn1 !== undefined || sortColumn2 !== undefined) {
                                    sortColumn1 = sortColumn1.get(sortObject) + " " + object1.model.get(sortObject);
                                    sortColumn2 = sortColumn2.get(sortObject) + " " + object2.model.get(sortObject);
                                }
                            }
                            else if (name === "Application Environment"){
                                var sortColumn1a = object1.model.get(sortObject);
                                var sortColumn2a = object2.model.get(sortObject);
                                if (sortColumn1a !== undefined || sortColumn2a !== undefined) {
                                    sortColumn1 += " " + object1.model.get(sortObject).get(sortColumn);
                                    sortColumn2 += " " + object2.model.get(sortObject).get(sortColumn);
                                }
                            }
                            if (sortColumn1 === undefined){
                                result = 1;
                            }
                            else if (sortColumn2 === undefined){
                                result = -1;
                            }
                            else if (sortColumn1 < sortColumn2){
                                result = -1;
                            }
                                else if (sortColumn1 > sortColumn2){
                                result = 1;
                            }
                        }
                        if (sortStatus){
                            result *= -1;
                        }
                        return result;
                    });
                    array.forEach(this.childWidgets, function(member) {
                        member.placeAt(_this.listAttach);
                    });
                    _this._setEvenOddClasses();
                }
            });
            domConstruct.create("div", {
                "innerHTML": i18n("Application Environments"),
                "className": "association-title"
            }, applicationList.titleAttach);
            domClass.add(applicationList.listAttach, "scrollable-rows");
            applicationList.placeAt(this.associatorAttach);
        },


        toggleAssociationExpand: function(expand){
            var associations = registry.byNode(query(".association-list")[0]).childWidgets;
            array.forEach(associations, function(association){
                if (expand){
                    association.showAssociationExpand();
                }
                else {
                    association.hideAssociationExpand();
                }
            });
        },

        refresh: function() {
            this.inherited(arguments);
        }
    });
});
