/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/dom-class",
    "dojo/dom-construct",
    "app/widgets/CheckboxResourceRow"
], function (
    declare,
    domClass,
    domConstruct,
    CheckboxResourceRow
) {
    return declare("app/widgets/scheduledDeployment/ScheduledDeploymentRow",[CheckboxResourceRow], {

        /**
         *
         */
        postCreate: function() {
            this.inherited(arguments);
            domClass.add(this.domNode, "resource-row scheduled-deployment-list-item");
        },

        /**
         *
         */
        getColumns: function() {
            var _this = this;
            return [{
                "name": i18n("Execution Date"),
                "width": "19%",
                "sortBy": "scheduledDate",
                "formatter": function() {
                    return domConstruct.create("a", {
                        "innerHTML": util.dateFormatShort(_this.model.get("scheduledDate")),
                        "href": uReleaseConfig.urls.base+"scheduledDeployment/"+_this.model.get("id")+"#execution"
                    });
                },
                "filterData": {}
            },{
                "name": i18n("Release"),
                "width": "23%",
                "sortBy": "release",
                "sortByObject": "name",
                "getValue": function() {
                    var release = _this.model.get("release");
                    return !!release ? release.get("name") : null;
                },
                "filterData": {
                    "type": "Text"
                }
            },{
                "name": i18n("Environment"),
                "width": "17%",
                "sortBy": "environment",
                "sortByObject": "name",
                "getValue": function() {
                    var environment = _this.model.get("environment");
                    return !!environment ? environment.get("name") : null;
                },
                "filterData": {
                    "type": "Text"
                }
            },/*  TEMPORARILY DISABLED UNTIL BACK END CAN CALCULATE THESE MORE EFFICIENTLY
                  SEE scheduledDeployment/ScheduledDeploymentRow.js
                  note that the other rows have had their widths adjusted since this was removed.
                  When we re-introduce this, we'll need to rebalance them again.
            {
                "name": i18n("Gate Status"),
                "width": "10%",
                "sortBy": "gateStatus",
                "getValue": function() {
                    var result = "";
                    if (_this.model.get("gateStatus") === "PASSED") {
                        result = i18n("Passed");
                    }
                    else {
                        result = i18n("Failed");
                    }
                    return result;
                },
                "filterData": {
                    "type": "Text"
                }
            },*/{
                "name": i18n("Plan Status"),
                "width": "15%",
                "sortBy": "status",
                "getValue": function() {
                    return _this.model.getDisplayStatus();
                },
                "filterData": {
                    "type": "Text"
                }
            },{
                "name": i18n("Creation Source"),
                "width": "20%",
                "sortBy": "rule",
                "sortByObject": "rule",
                "formatter": function() {
                    var result = i18n("Manual");
                    var rule = _this.model.get("rule");
                    if (!!rule) {
                        result = domConstruct.create("a", {
                            innerHTML: i18n("Recurring: %s", rule.get("rule")),
                            href: uReleaseConfig.urls.base+"scheduledDeployment/#recurring"
                        });
                    }
                    return result;
                }
            }];
        },


        // This is always true to suppress the inline-form "pencil"
        isReadOnly: function() {
            return true;
        },

        canDelete: function() {
            var result = this.inherited(arguments);
            if (this.model.get("status") === "NOTSTARTED") {
                result = true;
            }
            return result;
        },
        postDelete: function(){
            //Refresh the upcoming and calendar tab to reflect newly added deployment
            var tabManager = this.containingList.tabManager;
            tabManager.refreshTab("calendar");
        }
    });
});
