/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013, 2014, 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/dom-construct",
    "dojo/dom-class",
    "dojo/_base/lang",
    "app/widgets/UReleaseWidget",
    "app/model/ResourceRegistry",
    "app/widgets/CheckboxResourceTable",
    "./AssociationDialogRow",
    "app/model/scheduledDeployment/ScheduledDeploymentShallow",
    "js/webext/widgets/Dialog",
    "js/webext/widgets/ColumnForm"
], function(
    declare,
    domConstruct,
    domClass,
    lang,
    _URWidget,
    Registry,
    CheckboxResourceTable,
    ScheduledDeploymentShallowRow,
    ScheduledDeploymentShallow,
    Dialog,
    ColumnForm
) {
    var AssociationDialogContent = declare([_URWidget],{
        templateString:
            '<div class="association-dialog">' +
                '<div class="association-dialog-form" data-dojo-attach-point="formAP"></div>' +
            '</div>',
        postCreate: function () {
            this.inherited(arguments);
            var _this = this;

            var sd = new Registry().get(ScheduledDeploymentShallow);
            sd.canExpand = function () {
                return false;
            };
            sd.canWrite = function () {
                return false;
            };
            sd.canAddMember = function () {
                return false;
            };
            var OverriddenDeploymentHack = declare([ScheduledDeploymentShallowRow], {
                postCreate:function () {
                    this.model.canWrite = function () {
                        return false;
                    };
                    this.inherited(arguments);
                }
            });
            this.associationTable = new CheckboxResourceTable({
                model:sd,
                widgetClass:OverriddenDeploymentHack,
                labelNode:_this.addAP
            });
            this.associationTable.useStandby();
            this.associationTable.standby.show();
            this.associationTable.domNode.style.minHeight = "40px";
            sd.load().then(function () {
                _this.associationTable.standby.hide();
                if (_this.resource) {
                    // fix this to associate scheduled deployments with fedDeployment Resource
                    _this.associationTable.setSelectedById(_this.resource.get('scheduledDeployments'));
                }
            });


            var url = uReleaseConfig.urls.base+"federatedDashboard/" + (this.resource ? this.resource.get('id') : "");
            if (this.form) {
                this.form.destroy();
            }
            this.form = new ColumnForm({
                submitUrl:url,
                submitMethod: this.resource ? "PUT": "POST",
                submitFormat: "JSON",
                validateFields: function(data) {
                    var validationMessages = [];
                    if (data.name.length > 36) {
                        validationMessages.push(i18n("Name length must be less than 36 characters."));
                    }
                    if (data.description && data.description.length > 4000) {
                        validationMessages.push(i18n("Description length must be less than 4000 characters."));
                    }
                    return validationMessages;
                },
                fields:[{
                    name:"name",
                    label:i18n("Name"),
                    type:"text",
                    value: this.resource ? this.resource.get('name') : ""
                },{
                    name:"description",
                    label:i18n("Description"),
                    type:"textarea",
                    value: this.resource ? this.resource.get('description') : ""
                },{
                    name: "scheduledDeployments",
                    label:i18n("Scheduled Deployments"),
                    widget: this.associationTable
                }],
                postSubmit: function() {
                    // warning, dangling load.
                    if(_this.resource && _this.resource.get('id')) {
                        _this.resource.load().then( function () {
                            _this.dialog._postSubmit(_this.form.submitMethod, _this.resource.get('id'));
                            // Reload the page.
                            // Only other option is modifying what is already on the page, which can be costly
                            // because DOM manipulation on large data sets is costly.
                            //
                            // TODO - Find a better way of doing this in the future.
                            location.reload();
                        });
                    } else {
                        _this.dialog._postSubmit(_this.form.submitMethod, null);
                    }
                    _this.dialog.hide();
                },
                onCancel: function() {
                    _this.dialog.hide();
                },
                preSubmit: function (data) {
                    data.scheduledDeployments = _this.associationTable.getSelected('id');
                }
            });
            this.form.placeAt(this.formAP);
        },
        refresh: function (Resource, id) {
            this.dialog.set('title', i18n('New Federated Deployment Dashboard'));
            // We should never have a resource when starting because we will load anyway
            this.resource = null;

            if(id.length > 0) {
                this.resource = new Registry().get(Resource, id);
                var dialogSet = function() {
                    this.dialog.set('title', i18n("Editing: %s", this.resource.get('name')));
                };
                // Hitch the callbacks we need
                var setDialog = lang.hitch(this, dialogSet);
                var postCreateHitch = lang.hitch(this, this.postCreate);
                // Make sure we have the data we need to proceed
                this.resource.load().then( function() {
                    setDialog();
                    postCreateHitch();
                });
            }
            domConstruct.empty(this.formAP);
            // If we don't have a resource we call postCreate.
            // This should only happen one "Create New"
            if (!this.resource) {
                this.postCreate();
            }
        }
    });
    return declare("app/widgets/federatedDashboard/AssociationDialog", [_URWidget, Dialog],{
        postCreate: function() {
            this.adc = new AssociationDialogContent({
                model:this.resource,
                dialog:this
            });
            domClass.add(this.containerNode,"association-dialog");
            domClass.add(this.domNode,"scrollable-dialog");
            this.adc.placeAt(this.containerNode);

            this.own(this.adc);
            this.inherited(arguments);
        },
        refresh: function (Resource, id) {
            this.adc.refresh(Resource, id);
        },
        style:{
            "width":"80%"
        },
        _postSubmit : function (method /* PUT or POST */, id /* resource id, if any*/) {
            //no-op by default
        }
    });
});
