define([
    'js/webext/widgets/Dialog'
], function (
    Dialog
) {

    /**
        * a collection of generic ways to handle xhr request responses.
        * use one of these methods instead of re-writing an existing inline function.
        */
    return {
        handleError: function (error) {
            console.error(i18n("Error processing result from load:"),
                            error,
                            error.message);

            // attempt to extract a response code from the error.
            // Either of these will return null if the error does not have
            // the property
            var errorStatus = !!error.response ?
                error.response.status : error.status;

            // if all else fails, just use the base error object.
            if (!errorStatus) {
                errorStatus = error;
            }
            if(errorStatus === 401) {
                var dialog = new Dialog({
                    title:i18n("Authentication Error"),
                    content:i18n("401: User not authenticated.")
                });
                dialog.show();
            }
        }
    };
});
