/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define('app/util/urColor', [], function () {
    "use strict";
    return {
        /**
         * CONSTANTS
         */
        PROGRESS_BASE_GRAY:     "rgb(240, 240, 236)",
        PROGRESS_ACCENT_GRAY:   "rgb(200, 200, 185)",
        PROGRESS_BASE_RED:      "rgb(251, 231, 232)",
        PROGRESS_ACCENT_RED:    "rgb(236, 146, 155)",
        PROGRESS_BASE_GREEN:    "rgb(233, 243, 219)",
        PROGRESS_ACCENT_GREEN:  "rgb(157, 199, 99)",
        PROGRESS_BASE_BLUE:     "rgb(209, 228, 251)",
        PROGRESS_ACCENT_BLUE:   "rgb(156, 188, 239)",
        PROGRESS_BASE_YELLOW:   "rgb(247, 234, 198)",
        PROGRESS_ACCENT_YELLOW: "rgb(236, 202, 112)",
        PROGRESS_WHITE: "rgb(255, 255, 255)",

        /**
         * METHODS
         */
        /**
         * @param status String a status by which to look up a color
         */
        getColorsForStatus: function (status) {
            var colorObject = {};
            switch(status) {
                case 'ABORTED':
                case 'FAILED':
                case 'LATE':
                    colorObject = {
                        primary: this.PROGRESS_ACCENT_RED,//"rgb(236, 146, 155)";
                        secondary: this.PROGRESS_BASE_RED//"rgb(251, 231, 232)";
                    };
                    break;
                case 'COMPLETE':
                    colorObject = {
                        primary: this.PROGRESS_ACCENT_GREEN,//"rgb(157, 199, 99)";
                        secondary: this.PROGRESS_BASE_GREEN//"rgb(233, 243, 219)";
                    };
                    break;
                case "NOTSTARTED":
                    colorObject = {
                        primary: this.PROGRESS_ACCENT_BLUE,//"rgb(156, 188, 239)";
                        secondary: this.PROGRESS_BASE_BLUE//"rgb(209, 228, 251)";
                    };
                    break;
                case 'EXECUTING':
                case "INPROGRESS":
                    colorObject = {
                        primary: this.PROGRESS_ACCENT_YELLOW,//"rgb(236, 202, 112)";
                        secondary: this.PROGRESS_BASE_YELLOW//"rgb(247, 234, 198)";
                    };
                    break;
                case 'SKIPPED':
                    throw new Error(i18n('there is no color scheme for status') + status, i18n("in case SKIPPED"));
                case "OPEN":
                case "WAITING":
                    throw new Error(i18n('there is no color scheme for status') + status, i18n("in case OPEN WAITING"));
                default: // case 'UNMENTPREREQS', case'EMPTY'
                    colorObject = {
                        primary: this.PROGRESS_ACCENT_GRAY,//"rgb(236, 202, 112)";
                        secondary: this.PROGRESS_BASE_GRAY//"rgb(247, 234, 198)";
                    };
                    break;
            }
            return colorObject;
        }
    };
});

