/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define('app/util/String', [], function () {
    "use strict";

    String.prototype.capitalize = function () {
        return this.charAt(0).toUpperCase() + this.slice(1);
    };

    String.prototype.classify = function () {
        var str = this.replace(/[\W_]\w/g,
            function (s) {
                return s.substr(1).toUpperCase();
            });
                return str.replace(/s$/, '').capitalize();
    };
    String.prototype.uriify = function () {
            var uri = this.replace(/[a-z][A-Z]/g,
                function (s) {
                    return s.substr(0,1) + "_" + s.substr(1,1);
                });
            if(uri.substr(-1).toLowerCase() !== 's') {
                uri = uri + "s";
            }
            return uri.toLowerCase();
    };
});

