/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "app/model/Resource",
    "app/model/calendar/CalendarEntry"
],function (
    declare,
    Resource,
    CalendarEntry
) {
    /*
     * This is a subclass of CalendarEntry that is going to be used exclusively for
     * the calendar drop down. This is because the "all" rest endpoint will not
     * filter by Type, Release, or Environment. But the base "calendar" end point
     * will.
     *
     */
    return declare("app/model/calendar/CalendarDropdownEntry",[CalendarEntry], {
        getResourcePath: function() {
            return this.baseUrl + "calendar/all";
        }
    });
});