/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/_base/array"
], function (
    declare,
    lang,
    array
) {

    /**
     * Creates and maintains references to instances of Resource.  Prevents the creation of multiple
     * instances of the same REST access point.
     * Takes an object following:
     */
    return declare("app/model/ResourceRegistry",
            [], {

        /**
         * Checks the resource registry for an existing resource and returns it.  Otherwise instantiates a new resource, and returns it.
         * params:
         *      ModelClass : a Resource class or subclass
         *      modelArgs : arguments used to instantiate a Resource class (Object, string, empty)
         *      parentResource : The parent resource if this is a collection - when a collection resource
         *                       is created, it should be scoped to its parent if there is one.
         */
        get: function (ModelClass, modelArgs, parentResource) {
            var _this = this;

            // if the ModelClass is a string, turn it into a dojo class (declaredClass)
            if (typeof ModelClass === "string") {
                ModelClass = lang.getObject(ModelClass);
            }

            return new ModelClass(modelArgs, parentResource);
        }
    });
});
