/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.urbancode.sync.util;

import com.ibm.cloud.urbancode.sync.SyncApplicationProperties;
import com.urbancode.commons.util.ObjectUtil;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UsersUtil {
    public static String patternsToRegex(String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] patterns = pattern.split(",|\\n");
        for (int i = 0; i < patterns.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(patterns[i].replace(".", "\\.").replace("*", ".*"));
        }
        return sb.toString();
    }

    public static boolean isUserAllowed(String user, String registrar, String users) {
        if (ObjectUtil.isEqual((Object)user, (Object)registrar)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)users)) {
            Pattern pattern = Pattern.compile(users);
            Matcher matcher = pattern.matcher(user);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isUserAllowed(String user) {
        Properties props = SyncApplicationProperties.getProperties();
        String registrar = props.getProperty("sync.registrar");
        String users = props.getProperty("sync.users");
        return UsersUtil.isUserAllowed(user, registrar, UsersUtil.patternsToRegex(users));
    }
}

